/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.experimental;

import com.google.common.collect.BiMap;
import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.obfuscation.api.Obfuscatable;
import de.alpharogroup.crypto.obfuscation.rules.SimpleObfuscationRules;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Obfuscator
implements Obfuscatable {
    private final SimpleObfuscationRules rule;
    private final String key;

    public Obfuscator(SimpleObfuscationRules rule, String key) {
        Check.get().notNull((Object)rule, "rule");
        Check.get().notEmpty((CharSequence)key, "key");
        this.rule = rule;
        this.key = key;
    }

    public String disentangle() {
        String clonedKey = this.obfuscate();
        BiMap rules = this.rule.getObfuscationRules();
        for (Map.Entry rule : rules.entrySet()) {
            clonedKey = StringUtils.replace((String)clonedKey, (String)((String)rule.getValue()), (String)((String)rule.getKey()));
        }
        return clonedKey;
    }

    public String obfuscate() {
        BiMap rules = this.rule.getObfuscationRules();
        String clonedKey = this.key;
        for (Map.Entry rule : rules.entrySet()) {
            clonedKey = StringUtils.replace((String)clonedKey, (String)((String)rule.getKey()), (String)((String)rule.getValue()));
        }
        return clonedKey;
    }
}

