/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.blockchain;

import de.alpharogroup.crypto.algorithm.HashAlgorithm;
import de.alpharogroup.crypto.blockchain.api.IBlock;
import de.alpharogroup.crypto.blockchain.api.ITransaction;
import de.alpharogroup.crypto.hash.HashExtensions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Block
implements IBlock {
    private byte[] hash;
    private byte[] merkleRoot;
    private byte[] previousBlockHash;
    private long timestamp;
    private List<ITransaction> transactions;
    private long tries;

    public Block(byte[] previousBlockHash, List<ITransaction> transactions, long tries) {
        this.previousBlockHash = previousBlockHash;
        this.transactions = transactions;
        this.tries = tries;
        this.timestamp = System.currentTimeMillis();
        this.merkleRoot = HashExtensions.getMerkleRootHash(new LinkedList(transactions.stream().map(ITransaction::getHash).collect(Collectors.toList())), (HashAlgorithm)HashAlgorithm.SHA256);
        this.hash = HashExtensions.hash((byte[])previousBlockHash, (byte[])this.merkleRoot, (long)tries, (long)this.timestamp, (HashAlgorithm)HashAlgorithm.SHA256);
    }

    public int getLeadingZerosCount() {
        for (int i = 0; i < this.getHash().length; ++i) {
            if (this.getHash()[i] == 0) continue;
            return i;
        }
        return this.getHash().length;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getMerkleRoot() {
        return this.merkleRoot;
    }

    public byte[] getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<ITransaction> getTransactions() {
        return this.transactions;
    }

    public long getTries() {
        return this.tries;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public void setMerkleRoot(byte[] merkleRoot) {
        this.merkleRoot = merkleRoot;
    }

    public void setPreviousBlockHash(byte[] previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTransactions(List<ITransaction> transactions) {
        this.transactions = transactions;
    }

    public void setTries(long tries) {
        this.tries = tries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Block)) {
            return false;
        }
        Block other = (Block)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getHash(), other.getHash())) {
            return false;
        }
        if (!Arrays.equals(this.getMerkleRoot(), other.getMerkleRoot())) {
            return false;
        }
        if (!Arrays.equals(this.getPreviousBlockHash(), other.getPreviousBlockHash())) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        List<ITransaction> this$transactions = this.getTransactions();
        List<ITransaction> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        return this.getTries() == other.getTries();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Block;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getHash());
        result = result * 59 + Arrays.hashCode(this.getMerkleRoot());
        result = result * 59 + Arrays.hashCode(this.getPreviousBlockHash());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        List<ITransaction> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        long $tries = this.getTries();
        result = result * 59 + (int)($tries >>> 32 ^ $tries);
        return result;
    }

    public Block() {
    }
}

