/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.blockchain;

import de.alpharogroup.crypto.algorithm.HashAlgorithm;
import de.alpharogroup.crypto.blockchain.api.ITransaction;
import de.alpharogroup.crypto.hash.HashExtensions;
import java.util.Arrays;

public class Transaction
implements ITransaction {
    private byte[] hash;
    private byte[] senderHash;
    private byte[] signature;
    private String text;
    private long timestamp;

    public Transaction(String text, byte[] senderHash, byte[] signature) {
        this.text = text;
        this.senderHash = senderHash;
        this.signature = signature;
        this.timestamp = System.currentTimeMillis();
        this.hash = HashExtensions.hash((byte[])text.getBytes(), (byte[])senderHash, (byte[])signature, (long)this.timestamp, (HashAlgorithm)HashAlgorithm.SHA256);
    }

    public byte[] getSignableData() {
        return this.text.getBytes();
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getSenderHash() {
        return this.senderHash;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getText() {
        return this.text;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public void setSenderHash(byte[] senderHash) {
        this.senderHash = senderHash;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getHash(), other.getHash())) {
            return false;
        }
        if (!Arrays.equals(this.getSenderHash(), other.getSenderHash())) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getHash());
        result = result * 59 + Arrays.hashCode(this.getSenderHash());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }

    public Transaction() {
    }
}

