/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.character;

import com.google.common.collect.BiMap;
import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.obfuscation.api.Obfuscatable;
import de.alpharogroup.crypto.obfuscation.character.ObfuscatorExtensions;
import de.alpharogroup.crypto.obfuscation.rule.ObfuscationOperationRule;
import lombok.NonNull;

public class CharacterObfuscator
implements Obfuscatable {
    private boolean disentanglable;
    private final String key;
    private final BiMap<Character, ObfuscationOperationRule<Character, Character>> rules;

    public CharacterObfuscator(@NonNull BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, @NonNull String key) {
        this(rules, key, false);
        if (rules == null) {
            throw new NullPointerException("rules is marked @NonNull but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
    }

    public CharacterObfuscator(@NonNull BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, @NonNull String key, boolean validate) {
        if (rules == null) {
            throw new NullPointerException("rules is marked @NonNull but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Check.get().notEmpty(rules, "rules");
        Check.get().notEmpty((CharSequence)key, "key");
        this.rules = rules;
        this.key = key;
        if (validate) {
            this.disentanglable = ObfuscatorExtensions.validate(this.rules);
        }
    }

    public String disentangle() {
        String obfuscated = ObfuscatorExtensions.obfuscateWith(this.rules, this.key);
        String disentangled = ObfuscatorExtensions.disentangle(this.rules, obfuscated);
        return disentangled;
    }

    public String obfuscate() {
        String obfuscated = ObfuscatorExtensions.obfuscateWith(this.rules, this.key);
        return obfuscated;
    }

    public boolean isDisentanglable() {
        return this.disentanglable;
    }
}

