/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.file;

import de.alpharogroup.crypto.core.AbstractFileDecryptor;
import de.alpharogroup.crypto.io.CryptoCipherOutputStream;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FilenameUtils;

public class FileDecryptor
extends AbstractFileDecryptor {
    private static final long serialVersionUID = 1L;
    private File decryptedFile;

    public FileDecryptor(CryptModel<Cipher, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public FileDecryptor(CryptModel<Cipher, String> model, File decryptedFile) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        this.decryptedFile = decryptedFile;
    }

    public File decrypt(File encrypted) throws Exception {
        int c;
        if (this.decryptedFile == null) {
            String filename = FilenameUtils.getBaseName((String)encrypted.getName());
            this.decryptedFile = this.newDecryptedFile(encrypted.getParent(), filename + ".decrypted");
        }
        FileOutputStream decryptedOut = new FileOutputStream(this.decryptedFile);
        CryptoCipherOutputStream cos = new CryptoCipherOutputStream(decryptedOut, (Cipher)this.getModel().getCipher());
        FileInputStream fileInputStream = new FileInputStream(encrypted);
        while ((c = ((InputStream)fileInputStream).read()) != -1) {
            cos.write(c);
        }
        ((InputStream)fileInputStream).close();
        cos.close();
        return this.decryptedFile;
    }

    protected File newDecryptedFile(String parent, String child) {
        return new File(parent, child);
    }
}

