/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.simple;

import com.google.common.collect.BiMap;
import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.obfuscation.api.Obfuscatable;
import de.alpharogroup.crypto.obfuscation.rule.ObfuscationRule;
import de.alpharogroup.crypto.obfuscation.simple.SimpleObfuscatorExtensions;
import lombok.NonNull;

public class SimpleCharacterObfuscator
implements Obfuscatable {
    private final BiMap<Character, Character> biMap;
    private final String key;
    private final BiMap<Character, ObfuscationRule<Character, Character>> rules;

    public SimpleCharacterObfuscator(@NonNull BiMap<Character, ObfuscationRule<Character, Character>> rules, @NonNull String key) {
        if (rules == null) {
            throw new NullPointerException("rules is marked @NonNull but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Check.get().notEmpty(rules, "rules");
        Check.get().notEmpty((CharSequence)key, "key");
        this.rules = rules;
        this.biMap = SimpleObfuscatorExtensions.toCharacterBiMap(rules);
        this.key = key;
    }

    public String disentangle() {
        String obfuscated = SimpleObfuscatorExtensions.obfuscateWith(this.rules, this.key);
        return this.disentangle(obfuscated);
    }

    public String disentangle(String obfuscated) {
        String disentangled = SimpleObfuscatorExtensions.disentangleBiMap(this.biMap, obfuscated);
        return disentangled;
    }

    public String obfuscate() {
        String obfuscated = SimpleObfuscatorExtensions.obfuscateWith(this.rules, this.key);
        return obfuscated;
    }
}

