/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.simple;

import de.alpharogroup.crypto.CryptConst;
import de.alpharogroup.crypto.api.Cryptor;
import de.alpharogroup.crypto.api.StringDecryptor;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import lombok.NonNull;

public class SimpleDecryptor
implements StringDecryptor,
Cryptor {
    private Cipher cipher;
    private boolean initialized;
    private final String privateKey;

    public SimpleDecryptor(@NonNull String privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked @NonNull but is null");
        }
        this.privateKey = privateKey;
    }

    public String decrypt(String encypted) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        this.initialize();
        byte[] dec = Base64.getDecoder().decode(encypted);
        byte[] utf8 = this.cipher.doFinal(dec);
        return new String(utf8, StandardCharsets.UTF_8.name());
    }

    private void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            PBEKeySpec keySpec = new PBEKeySpec(this.getPrivateKey().toCharArray());
            SecretKeyFactory factory = SecretKeyFactory.getInstance(CryptConst.PBE_WITH_MD5_AND_DES);
            SecretKey key = factory.generateSecret(keySpec);
            this.cipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(CryptConst.SALT, 19);
            this.cipher.init(this.newOperationMode(), (Key)key, paramSpec);
            this.initialized = true;
        }
    }

    public int newOperationMode() {
        return 2;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }
}

