/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.character;

import com.google.common.collect.BiMap;
import de.alpharogroup.crypto.obfuscation.rule.ObfuscationOperationRule;
import de.alpharogroup.crypto.obfuscation.rule.Operation;
import java.util.Map;
import java.util.Set;

public final class ObfuscatorExtensions {
    public static String obfuscateWith(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String toObfuscate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toObfuscate.length(); ++i) {
            char currentCharacter = toObfuscate.charAt(i);
            Character asCharacter = Character.valueOf(currentCharacter);
            String charAsString = Character.toString(currentCharacter);
            if (rules.containsKey((Object)asCharacter)) {
                ObfuscationOperationRule obfuscationOperationRule = (ObfuscationOperationRule)rules.get((Object)asCharacter);
                Set indexes = obfuscationOperationRule.getIndexes();
                Operation operation = obfuscationOperationRule.getOperation();
                if (operation != null) {
                    obfuscationOperationRule.setOperatedCharacter((Object)Operation.operate((char)currentCharacter, (Operation)operation));
                }
                if (indexes.contains(i) && obfuscationOperationRule.getOperatedCharacter() != null) {
                    sb.append(obfuscationOperationRule.getOperatedCharacter());
                    continue;
                }
                Character replaceWith = (Character)obfuscationOperationRule.getReplaceWith();
                sb.append(replaceWith);
                continue;
            }
            sb.append(charAsString);
        }
        return sb.toString();
    }

    public static String disentangle(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String obfuscated) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < obfuscated.length(); ++i) {
            boolean processed = false;
            char currentChar = obfuscated.charAt(i);
            boolean upperCase = Character.isUpperCase(currentChar);
            boolean lowerCase = Character.isLowerCase(currentChar);
            Character currentCharacter = Character.valueOf(currentChar);
            for (Map.Entry entry : rules.entrySet()) {
                ObfuscationOperationRule obfuscationOperationRule = (ObfuscationOperationRule)entry.getValue();
                Set indexes = obfuscationOperationRule.getIndexes();
                Operation operation = obfuscationOperationRule.getOperation();
                if (operation != null) {
                    obfuscationOperationRule.setOperatedCharacter((Object)Operation.operate((char)currentCharacter.charValue(), (Operation)operation));
                }
                Character character = (Character)obfuscationOperationRule.getCharacter();
                Character replaceWith = (Character)obfuscationOperationRule.getReplaceWith();
                if (!indexes.isEmpty() && indexes.contains(i) && operation != null) {
                    Character operatedCharacter = Operation.operate((char)character.charValue(), (Operation)operation);
                    if (currentCharacter.equals(operatedCharacter)) {
                        if (operation.equals((Object)Operation.UPPERCASE) && upperCase || operation.equals((Object)Operation.LOWERCASE) && lowerCase) {
                            sb.append(Operation.operate((char)currentChar, (Operation)operation, (boolean)true));
                        } else {
                            sb.append(Operation.operate((char)currentChar, (Operation)operation, (boolean)false));
                        }
                        processed = true;
                        continue;
                    }
                    if (currentCharacter.equals(replaceWith)) {
                        sb.append(character);
                        processed = true;
                        continue;
                    }
                }
                if (!currentCharacter.equals(replaceWith) || !rules.containsKey((Object)replaceWith)) continue;
                sb.append(character);
                processed = true;
            }
            if (processed || rules.containsKey((Object)currentCharacter)) continue;
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static boolean validate(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules) {
        Set keySet = rules.keySet();
        for (Map.Entry entry : rules.entrySet()) {
            ObfuscationOperationRule value = (ObfuscationOperationRule)entry.getValue();
            Character operatedCharacter = Operation.operate((char)((Character)value.getCharacter()).charValue(), (Operation)value.getOperation());
            if (!keySet.contains(operatedCharacter)) continue;
            return false;
        }
        return true;
    }

    private ObfuscatorExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

