/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.processors.bruteforce;

import de.alpharogroup.crypto.key.reader.EncryptedPrivateKeyReader;
import de.alpharogroup.crypto.key.reader.PrivateKeyReader;
import de.alpharogroup.crypto.processors.bruteforce.BruteForceProcessor;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import lombok.NonNull;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class PrivateKeyBruteForceProcessor {
    public static Optional<String> resolvePassword(File privateKeyFile, @NonNull BruteForceProcessor processor) {
        Optional<String> optionalPassword;
        block6: {
            if (processor == null) {
                throw new NullPointerException("processor is marked non-null but is null");
            }
            optionalPassword = Optional.empty();
            try {
                boolean isPasswordProtected = PrivateKeyReader.isPrivateKeyPasswordProtected((File)privateKeyFile);
                if (isPasswordProtected) break block6;
                String attempt = processor.getCurrentAttempt();
                Security.addProvider((Provider)new BouncyCastleProvider());
                while (true) {
                    try {
                        EncryptedPrivateKeyReader.getKeyPair((File)privateKeyFile, (String)attempt);
                        optionalPassword = Optional.of(attempt);
                    }
                    catch (IOException e) {
                        attempt = processor.getCurrentAttempt();
                        processor.increment();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                return optionalPassword;
            }
        }
        return optionalPassword;
    }

    private PrivateKeyBruteForceProcessor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

