/*
 * Decompiled with CFR 0.152.
 */
package hbm.init;

import de.alpharogroup.file.create.CreateFileUtils;
import de.alpharogroup.file.read.ReadFileUtils;
import de.alpharogroup.file.search.PathFinder;
import de.alpharogroup.file.write.WriteFileUtils;
import de.alpharogroup.io.StreamUtils;
import de.alpharogroup.jdbc.ConnectionsUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.engine.jdbc.internal.DDLFormatterImpl;

public abstract class AbstractDatabaseInitialization {
    protected static final String DELETE_PROCESS = "delete";
    protected static final String CREATE_PROCESS = "create";
    protected static final String DROP_PROCESS = "drop";
    protected final Properties databaseProperties;
    protected String host;
    protected String databaseName;
    protected String databaseUser;
    protected String databasePassword;
    protected String initializationProcess;
    protected String fileEncoding;
    protected boolean log;
    protected boolean postgresDatabase;

    public AbstractDatabaseInitialization(Properties databaseProperties) {
        this.databaseProperties = databaseProperties;
        this.host = databaseProperties.getProperty("jdbc.host");
        this.databaseName = databaseProperties.getProperty("jdbc.db.name");
        this.databaseUser = databaseProperties.getProperty("jdbc.user");
        this.databasePassword = databaseProperties.getProperty("jdbc.password");
        this.initializationProcess = databaseProperties.getProperty("jdbc.create.db.process");
        this.fileEncoding = databaseProperties.getProperty("jdbc.file.encoding");
        this.log = BooleanUtils.toBoolean((String)databaseProperties.getProperty("jdbc.show.sql.log"));
        String vendor = databaseProperties.getProperty("jdbc.db.vendor");
        this.postgresDatabase = vendor != null && !vendor.isEmpty() ? BooleanUtils.toBoolean((String)vendor) : true;
    }

    public Properties getDatabaseProperties() {
        return this.databaseProperties;
    }

    public void initializeDatabase() throws ClassNotFoundException, SQLException, IOException {
        String processtype = this.getProcessType();
        if (processtype.equals(DELETE_PROCESS)) {
            this.deleteAndCreateEmptyDatabaseWithoutTables();
        }
        try (Connection jdbcConnection = ConnectionsUtils.getPostgreSQLConnection((String)this.host, (String)this.databaseName, (String)this.databaseUser, (String)this.databasePassword);){
            if (processtype.equals(DROP_PROCESS)) {
                this.dropTablesAndSequences(jdbcConnection);
            }
            this.createSchema(jdbcConnection, processtype);
            this.initializeDatabase(jdbcConnection);
        }
    }

    protected String getProcessType() {
        String arg;
        String processtype = DROP_PROCESS;
        if (this.initializationProcess != null && ((arg = this.initializationProcess).equals(DELETE_PROCESS) || arg.equals(DROP_PROCESS))) {
            processtype = arg;
        }
        return processtype;
    }

    protected void deleteAndCreateEmptyDatabaseWithoutTables() throws ClassNotFoundException, SQLException {
        ConnectionsUtils.dropPostgreSQLDatabase((String)this.host, (String)this.databaseName, (String)this.databaseUser, (String)this.databasePassword);
        this.newEmptyDatabaseWithoutTables();
    }

    protected void newEmptyDatabaseWithoutTables() throws ClassNotFoundException, SQLException {
        ConnectionsUtils.newPostgreSQLDatabase((String)this.host, (String)this.databaseName, (String)this.databaseUser, (String)this.databasePassword, (String)"", (String)"");
    }

    protected File getInsertDir() {
        File insertsDir = new File(this.getSqlDir(), "inserts");
        return insertsDir;
    }

    protected File getSqlDir() {
        File resDestDir = PathFinder.getSrcMainResourcesDir();
        File sqlDir = new File(resDestDir, "dll");
        return sqlDir;
    }

    protected void dropTablesAndSequences(Connection jdbcConnection) throws IOException, SQLException {
        File projectDir = PathFinder.getProjectDirectory();
        File dropSchemaSqlFile = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"src/main/resources/dll", (String)"dropSchema.sql");
        if (!dropSchemaSqlFile.exists()) {
            CreateFileUtils.newFileQuietly((File)dropSchemaSqlFile);
        }
        ConnectionsUtils.executeSqlScript((BufferedReader)((BufferedReader)StreamUtils.getReader((File)dropSchemaSqlFile, (String)this.fileEncoding, (boolean)false)), (Connection)jdbcConnection, (boolean)this.log);
    }

    protected boolean createInitializationScript(String processtype) throws IOException {
        File createIndexesAndForeignKeys;
        String result;
        String result2;
        File sqlDir = this.getSqlDir();
        File insertsDir = this.getInsertDir();
        StringBuilder sb = new StringBuilder();
        DDLFormatterImpl formatter = new DDLFormatterImpl();
        File schema = new File(sqlDir, "schema.sql");
        if (this.postgresDatabase) {
            result2 = this.replaceMediumblobToBytea(schema);
            sb.append(formatter.format(result2));
        } else {
            result2 = ReadFileUtils.readFromFile((File)schema);
            sb.append(formatter.format(result2));
        }
        sb.append(System.getProperty("line.separator"));
        sb.append(System.getProperty("line.separator"));
        if (processtype.equals(DELETE_PROCESS)) {
            File updateEnums;
            File createEnums = new File(sqlDir, "createEnumTypes.sql");
            if (createEnums.exists()) {
                result = ReadFileUtils.readFromFile((File)createEnums);
                sb.append(result);
                sb.append(System.getProperty("line.separator"));
            }
            if ((updateEnums = new File(sqlDir, "updateEnumFields.sql")).exists()) {
                String result3 = ReadFileUtils.readFromFile((File)updateEnums);
                sb.append(result3);
                sb.append(System.getProperty("line.separator"));
            }
        }
        if ((createIndexesAndForeignKeys = new File(sqlDir, "createIndexesAndForeignKeys.sql")).exists()) {
            result = ReadFileUtils.readFromFile((File)createIndexesAndForeignKeys);
            sb.append(result);
        }
        File initializeSchemaDdl = new File(insertsDir, "initializeSchema.sql");
        boolean writen = WriteFileUtils.writeStringToFile((File)initializeSchemaDdl, (String)sb.toString(), (String)this.fileEncoding);
        return writen;
    }

    protected String replaceMediumblobToBytea(File schema) throws IOException {
        String contentSchema = ReadFileUtils.readFromFile((File)schema);
        String result = StringUtils.replace((String)contentSchema, (String)"MEDIUMBLOB", (String)"BYTEA");
        WriteFileUtils.writeStringToFile((File)schema, (String)result, (String)"UTF-8");
        return result;
    }

    protected void createSchema(Connection jdbcConnection, String processtype) throws FileNotFoundException, IOException, SQLException {
        this.initializeScriptFiles();
        boolean writen = this.createInitializationScript(processtype);
        if (writen) {
            System.err.println(writen);
        }
        this.createSchemaFromScript(jdbcConnection);
    }

    protected void initializeScriptFiles() throws FileNotFoundException, IOException {
        File projectDir = PathFinder.getProjectDirectory();
        File schemaDllDir = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"target/hibernate3/sql", (String)"schema.ddl");
        if (schemaDllDir.exists()) {
            File schemaSqlDir = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"src/main/resources/dll", (String)"schema.sql");
            File dropSchemaSqlDir = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"src/main/resources/dll", (String)"dropSchema.sql");
            File createIndexesAndForeignKeys = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"src/main/resources/dll", (String)"createIndexesAndForeignKeys.sql");
            List lines = ReadFileUtils.readLinesInList((File)schemaDllDir);
            ArrayList<String> dropTables = new ArrayList<String>();
            ArrayList<String> createTables = new ArrayList<String>();
            ArrayList<String> createIndexesAndAlterTable = new ArrayList<String>();
            for (String currentLine : lines) {
                if (currentLine.startsWith("alter table") && currentLine.contains("drop constraint")) {
                    dropTables.add(currentLine);
                    continue;
                }
                if (currentLine.startsWith("drop ")) {
                    dropTables.add(currentLine);
                    continue;
                }
                if (currentLine.startsWith("create table")) {
                    createTables.add(currentLine);
                }
                if (!currentLine.startsWith("create index") && !currentLine.startsWith("alter table") && !currentLine.startsWith("create sequence")) continue;
                createIndexesAndAlterTable.add(currentLine);
            }
            WriteFileUtils.writeLinesToFile(dropTables, (File)dropSchemaSqlDir, (String)"UTF-8");
            WriteFileUtils.writeLinesToFile(createTables, (File)schemaSqlDir, (String)"UTF-8");
            WriteFileUtils.writeLinesToFile(createIndexesAndAlterTable, (File)createIndexesAndForeignKeys, (String)"UTF-8");
        }
    }

    protected void createSchemaFromScript(Connection jdbcConnection) throws IOException, SQLException {
        File insertsDir = this.getInsertDir();
        File initializeSchemaDdl = new File(insertsDir, "initializeSchema.sql");
        String result = ReadFileUtils.readFromFile((File)initializeSchemaDdl);
        ConnectionsUtils.executeSqlScript((Connection)jdbcConnection, (String)result, (boolean)this.log);
    }

    protected abstract List<File> getScriptFiles();

    protected void initializeDatabase(Connection jdbcConnection) throws IOException, SQLException {
        List<File> scriptFiles = this.getScriptFiles();
        int size = scriptFiles.size();
        for (int i = 0; i < size; ++i) {
            ConnectionsUtils.executeSqlScript((BufferedReader)((BufferedReader)StreamUtils.getReader((File)scriptFiles.get(i), (String)this.fileEncoding, (boolean)false)), (Connection)jdbcConnection, (boolean)this.log);
        }
    }
}

