/*
 * Decompiled with CFR 0.152.
 */
package hbm.dao.jpa;

import de.alpharogroup.lang.TypeArgumentsUtils;
import hbm.dao.jpa.EntityManagerDao;
import hbm.entity.BaseEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class JpaEntityManagerDao<T extends BaseEntity<PK>, PK extends Serializable>
implements EntityManagerDao<T, PK> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type = TypeArgumentsUtils.getFirstTypeArgument(JpaEntityManagerDao.class, this.getClass());
    @Autowired
    private DataSource dataSource;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public void create(T entity) {
        this.getEntityManager().persist(entity);
    }

    @Override
    public void update(T entity) {
        this.getEntityManager().merge(entity);
    }

    @Override
    public void delete(T entity) {
        this.getEntityManager().remove(entity);
    }

    @Override
    public void delete(List<T> objects) {
        for (BaseEntity entity : objects) {
            this.getEntityManager().remove((Object)entity);
        }
    }

    @Override
    public void delete(PK id) {
        T entity = this.get(id);
        this.delete((PK)entity);
    }

    @Override
    public boolean exists(PK id) {
        return this.get(id) != null;
    }

    @Override
    public List<T> findAll() {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(this.getType());
        Root root = cq.from(this.getType());
        cq.select((Selection)root);
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    @Override
    public T get(PK id) {
        if (id != null) {
            return (T)((BaseEntity)this.getEntityManager().find(this.type, id));
        }
        return null;
    }

    @Override
    public T load(PK id) {
        return this.get(id);
    }

    @Override
    public T merge(T object) {
        return (T)((BaseEntity)this.getEntityManager().merge(object));
    }

    @Override
    public void refresh(T object) {
        this.getEntityManager().refresh(object);
    }

    @Override
    public List<PK> save(List<T> objects) {
        ArrayList<PK> primaryKeys = new ArrayList<PK>();
        for (BaseEntity object : objects) {
            primaryKeys.add(this.save(object));
        }
        return primaryKeys;
    }

    @Override
    public List<T> merge(List<T> objects) {
        ArrayList<BaseEntity> mergedEntities = new ArrayList<BaseEntity>();
        for (BaseEntity object : objects) {
            mergedEntities.add(this.merge(object));
        }
        return mergedEntities;
    }

    @Override
    public PK save(T object) {
        this.getEntityManager().persist(object);
        return ((BaseEntity)object).getId();
    }

    @Override
    public void saveOrUpdate(List<T> objects) {
        this.save((T)objects);
    }

    @Override
    public void saveOrUpdate(T object) {
        this.save(object);
    }

    @Override
    public void update(List<T> objects) {
        for (BaseEntity t : objects) {
            this.update(t);
        }
    }

    @Override
    public void evict(T object) {
        this.getEntityManager().detach(object);
    }

    @Override
    public Query getQuery(String hqlQuery) {
        return this.getEntityManager().createQuery(hqlQuery);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }
}

