/*
 * Decompiled with CFR 0.152.
 */
package hbm.service.sessionfactory;

import hbm.dao.sessionfactory.SessionFactoryDao;
import hbm.entity.BaseEntity;
import hbm.service.jpa.BusinessService;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.type.Type;

public abstract class AbstractBusinessService<T extends BaseEntity<PK>, PK extends Serializable, DAO extends SessionFactoryDao<T, PK>>
implements BusinessService<T, PK> {
    private static final long serialVersionUID = 1L;
    private DAO dao;

    @Override
    public void delete(List<T> objects) {
        for (BaseEntity t : objects) {
            this.delete((T)t);
        }
    }

    @Override
    public void delete(PK id) {
        this.getDao().delete(id);
    }

    @Override
    public void delete(T id) {
        this.getDao().delete(id);
    }

    public void deleteAndFlush(List<T> objects) {
        this.delete((T)objects);
        this.flush();
    }

    public void deleteAndFlush(T t) {
        this.delete(t);
        this.flush();
    }

    public void deleteAndFlush(PK id) {
        this.delete((T)id);
        this.flush();
    }

    @Override
    public void evict(T object) {
        this.getDao().evict(object);
    }

    @Override
    public boolean exists(PK id) {
        return this.getDao().exists(id);
    }

    public List<T> find(String hqlQuery, String[] params, Object[] paramValues, Type[] paramTypes, Integer start, Integer count) {
        return this.getDao().find(hqlQuery, params, paramValues, paramTypes, start, count);
    }

    @Override
    public List<T> findAll() {
        return this.getDao().findAll();
    }

    public List<T> findByCriteria(Criterion ... criterion) {
        return this.getDao().findByCriteria(criterion);
    }

    public List<T> findByExample(T exampleInstance, String ... excludeProperty) {
        return this.getDao().findByExample(exampleInstance, excludeProperty);
    }

    public void flush() {
        this.getSession().flush();
    }

    @Override
    public T get(PK id) {
        return this.getDao().get(id);
    }

    public DAO getDao() {
        return this.dao;
    }

    public Query getQuery(String s) {
        return this.getDao().getQuery(s);
    }

    public Session getSession() {
        return this.getDao().getSession();
    }

    public void setSession(Session session) {
        this.getDao().setSession(session);
    }

    @Override
    public T load(PK id) {
        return this.getDao().load(id);
    }

    @Override
    public T merge(T object) {
        return this.getDao().merge(object);
    }

    public T mergeAndFlush(T object) {
        try {
            T t = this.merge(object);
            return t;
        }
        finally {
            this.flush();
        }
    }

    @Override
    public void refresh(T object) {
        this.getDao().refresh(object);
    }

    @Override
    public List<PK> save(List<T> objects) {
        return this.getDao().save(objects);
    }

    @Override
    public List<T> merge(List<T> objects) {
        return this.getDao().merge(objects);
    }

    @Override
    public PK save(T newInstance) {
        return this.getDao().save(newInstance);
    }

    public List<PK> saveAndFlush(List<T> objects) {
        try {
            PK PK = this.save((T)objects);
            return PK;
        }
        finally {
            this.flush();
        }
    }

    public PK saveAndFlush(T object) {
        try {
            PK PK = this.save(object);
            return PK;
        }
        finally {
            this.flush();
        }
    }

    @Override
    public void saveOrUpdate(List<T> objects) {
        this.getDao().saveOrUpdate(objects);
    }

    @Override
    public void saveOrUpdate(T object) {
        this.getDao().saveOrUpdate(object);
    }

    public void saveOrUpdateAndFlush(List<T> objects) {
        this.getDao().saveOrUpdate(objects);
        this.flush();
    }

    public void saveOrUpdateAndFlush(T object) {
        this.getDao().saveOrUpdate(object);
        this.flush();
    }

    public void setDao(DAO dao) {
        this.dao = dao;
    }
}

