/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.springconfig;

import de.alpharogroup.collections.ListExtensions;
import java.util.Collection;
import java.util.List;
import org.springframework.cache.CacheManager;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleCacheErrorHandler;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.cache.support.CompositeCacheManager;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class SpringCacheConfigurationFactory {
    public static CacheManager newCacheManager(CacheManager ... cacheCacheManager) {
        List cacheManagers = ListExtensions.newArrayList((Object[])new CacheManager[0]);
        for (CacheManager cm : cacheCacheManager) {
            if (cm == null) continue;
            cacheManagers.add(cm);
        }
        CompositeCacheManager cacheManager = new CompositeCacheManager();
        cacheManager.setCacheManagers((Collection)cacheManagers);
        cacheManager.setFallbackToNoOpCache(false);
        return cacheManager;
    }

    public static KeyGenerator newSimpleKeyGenerator() {
        return new SimpleKeyGenerator();
    }

    public static CacheResolver newSimpleCacheResolver() {
        return new SimpleCacheResolver();
    }

    public static CacheErrorHandler newSimpleCacheErrorHandler() {
        return new SimpleCacheErrorHandler();
    }

    public static EhCacheManagerFactoryBean newEhCacheManagerFactoryBean(String ehcacheXmlFilename) {
        EhCacheManagerFactoryBean cacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        cacheManagerFactoryBean.setConfigLocation((Resource)new ClassPathResource(ehcacheXmlFilename));
        cacheManagerFactoryBean.setShared(true);
        return cacheManagerFactoryBean;
    }

    public static EhCacheCacheManager newEhCacheCacheManager(EhCacheManagerFactoryBean cacheManagerFactoryBean) {
        EhCacheCacheManager cacheManger = new EhCacheCacheManager(cacheManagerFactoryBean.getObject());
        return cacheManger;
    }

    private SpringCacheConfigurationFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

