/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.springconfig;

import de.alpharogroup.collections.list.ListExtensions;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JdbcUrlBean {
    public static final JdbcUrlBean DEFAULT_POSTGRESQL_URL = JdbcUrlBean.builder().protocol("jdbc:postgresql://").host("localhost").port(5432).build();
    public static final JdbcUrlBean DEFAULT_MYSQL_URL = JdbcUrlBean.builder().protocol("jdbc:mysql://").host("localhost").port(3306).build();
    private String protocol;
    private String host;
    private int port;
    private String database;
    private List<String> parameters;

    public static String newDefaultMysqlJdbcUrl(String database) {
        return JdbcUrlBean.newMysqlJdbcUrl(DEFAULT_MYSQL_URL.toBuilder().database(database).build());
    }

    public static String newDefaultPostgresJdbcUrl(String database) {
        return JdbcUrlBean.newPostgresJdbcUrl(DEFAULT_POSTGRESQL_URL.toBuilder().database(database).build());
    }

    public static String newH2JdbcUrl(JdbcUrlBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getProtocol()).append(bean.getDatabase());
        if (ListExtensions.isNotEmpty(bean.getParameters())) {
            for (String parameter : bean.getParameters()) {
                sb.append(";").append(parameter);
            }
        }
        return sb.toString();
    }

    public static String newMysqlJdbcUrl(JdbcUrlBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getProtocol()).append(bean.getHost()).append(":").append(bean.getPort()).append("/").append(bean.getDatabase());
        return sb.toString();
    }

    public static String newPostgresJdbcUrl(JdbcUrlBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getProtocol()).append(bean.getHost()).append(":").append(bean.getPort()).append("/").append(bean.getDatabase());
        return sb.toString();
    }

    public static JdbcUrlBeanBuilder builder() {
        return new JdbcUrlBeanBuilder();
    }

    public JdbcUrlBeanBuilder toBuilder() {
        return new JdbcUrlBeanBuilder().protocol(this.protocol).host(this.host).port(this.port).database(this.database).parameters(this.parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcUrlBean)) {
            return false;
        }
        JdbcUrlBean other = (JdbcUrlBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        List<String> this$parameters = this.getParameters();
        List<String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcUrlBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        List<String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcUrlBean(protocol=" + this.getProtocol() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", parameters=" + this.getParameters() + ")";
    }

    public JdbcUrlBean() {
    }

    @ConstructorProperties(value={"protocol", "host", "port", "database", "parameters"})
    public JdbcUrlBean(String protocol, String host, int port, String database, List<String> parameters) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.database = database;
        this.parameters = parameters;
    }

    public static class JdbcUrlBeanBuilder {
        private String protocol;
        private String host;
        private int port;
        private String database;
        private ArrayList<String> parameters;

        JdbcUrlBeanBuilder() {
        }

        public JdbcUrlBeanBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public JdbcUrlBeanBuilder host(String host) {
            this.host = host;
            return this;
        }

        public JdbcUrlBeanBuilder port(int port) {
            this.port = port;
            return this;
        }

        public JdbcUrlBeanBuilder database(String database) {
            this.database = database;
            return this;
        }

        public JdbcUrlBeanBuilder parameter(String parameter) {
            if (this.parameters == null) {
                this.parameters = new ArrayList();
            }
            this.parameters.add(parameter);
            return this;
        }

        public JdbcUrlBeanBuilder parameters(Collection<? extends String> parameters) {
            if (this.parameters == null) {
                this.parameters = new ArrayList();
            }
            this.parameters.addAll(parameters);
            return this;
        }

        public JdbcUrlBeanBuilder clearParameters() {
            if (this.parameters != null) {
                this.parameters.clear();
            }
            return this;
        }

        public JdbcUrlBean build() {
            List<String> parameters;
            switch (this.parameters == null ? 0 : this.parameters.size()) {
                case 0: {
                    parameters = Collections.emptyList();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonList(this.parameters.get(0));
                    break;
                }
                default: {
                    parameters = Collections.unmodifiableList(new ArrayList<String>(this.parameters));
                }
            }
            return new JdbcUrlBean(this.protocol, this.host, this.port, this.database, parameters);
        }

        public String toString() {
            return "JdbcUrlBean.JdbcUrlBeanBuilder(protocol=" + this.protocol + ", host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", parameters=" + this.parameters + ")";
        }
    }
}

