/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.init;

import de.alpharogroup.file.create.CreateFileExtensions;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.file.search.PathFinder;
import de.alpharogroup.file.write.WriteFileExtensions;
import de.alpharogroup.io.StreamExtensions;
import de.alpharogroup.jdbc.ConnectionsExtensions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.engine.jdbc.internal.DDLFormatterImpl;

public abstract class AbstractDatabaseInitialization {
    protected static final String CREATE_EMPTY_PROCESS = "create-empty";
    protected static final String CREATE_PROCESS = "create";
    protected static final String DELETE_PROCESS = "delete";
    protected static final String DROP_PROCESS = "drop";
    public static final String JDBC_CREATE_DB_PROCESS_KEY = "jdbc.create.db.process";
    public static final String JDBC_DB_NAME_KEY = "jdbc.db.name";
    public static final String JDBC_DB_VENDOR_KEY = "jdbc.db.vendor";
    public static final String JDBC_FILE_ENCODING_KEY = "jdbc.file.encoding";
    public static final String JDBC_HOST_KEY = "jdbc.host";
    public static final String JDBC_PASSWORD_KEY = "jdbc.password";
    public static final String JDBC_SHOW_SQL_LOG_KEY = "jdbc.show.sql.log";
    public static final String JDBC_USER_KEY = "jdbc.user";
    protected static final Logger LOG = Logger.getLogger((String)AbstractDatabaseInitialization.class.getName());
    protected String databaseName;
    protected String databasePassword;
    protected final Properties databaseProperties;
    protected String databaseUser;
    protected String fileEncoding;
    protected String host;
    protected String initializationProcess;
    protected boolean log;
    protected boolean postgresDatabase;

    public AbstractDatabaseInitialization(Properties databaseProperties) {
        this.databaseProperties = databaseProperties;
        this.host = databaseProperties.getProperty(JDBC_HOST_KEY);
        this.databaseName = databaseProperties.getProperty(JDBC_DB_NAME_KEY);
        this.databaseUser = databaseProperties.getProperty(JDBC_USER_KEY);
        this.databasePassword = databaseProperties.getProperty(JDBC_PASSWORD_KEY);
        this.initializationProcess = databaseProperties.getProperty(JDBC_CREATE_DB_PROCESS_KEY);
        this.fileEncoding = databaseProperties.getProperty(JDBC_FILE_ENCODING_KEY, "UTF-8");
        this.log = BooleanUtils.toBoolean((String)databaseProperties.getProperty(JDBC_SHOW_SQL_LOG_KEY));
        String vendor = databaseProperties.getProperty(JDBC_DB_VENDOR_KEY);
        this.postgresDatabase = vendor != null && !vendor.isEmpty() ? BooleanUtils.toBoolean((String)vendor) : true;
    }

    protected boolean createInitializationScript(String processtype) throws IOException {
        File createIndexesAndForeignKeys;
        String result;
        File sqlDir = this.getSqlDir();
        File insertsDir = this.getInsertDir();
        StringBuilder sb = new StringBuilder();
        DDLFormatterImpl formatter = new DDLFormatterImpl();
        File schema = new File(sqlDir, "schema.sql");
        LOG.debug((Object)"start process of creation of initializeSchema.sql file.");
        LOG.debug((Object)"read from file schema.sql");
        String schemaString = this.postgresDatabase ? this.replaceMediumblobToBytea(schema) : ReadFileExtensions.readFromFile((File)schema);
        sb.append(formatter.format(schemaString));
        sb.append(System.getProperty("line.separator"));
        sb.append(System.getProperty("line.separator"));
        if (processtype.equals(DELETE_PROCESS)) {
            File updateEnums;
            File createEnums = new File(sqlDir, "createEnumTypes.sql");
            if (createEnums.exists()) {
                LOG.debug((Object)"read from file createEnumTypes.sql");
                result = ReadFileExtensions.readFromFile((File)createEnums);
                sb.append(result);
                sb.append(System.getProperty("line.separator"));
            }
            if ((updateEnums = new File(sqlDir, "updateEnumFields.sql")).exists()) {
                LOG.debug((Object)"read from file updateEnumFields.sql");
                String result2 = ReadFileExtensions.readFromFile((File)updateEnums);
                sb.append(result2);
                sb.append(System.getProperty("line.separator"));
            }
        }
        if ((createIndexesAndForeignKeys = new File(sqlDir, "createIndexesAndForeignKeys.sql")).exists()) {
            LOG.debug((Object)"read from file createIndexesAndForeignKeys.sql");
            result = ReadFileExtensions.readFromFile((File)createIndexesAndForeignKeys);
            sb.append(result);
        }
        File initializeSchemaDdl = new File(insertsDir, "initializeSchema.sql");
        LOG.debug((Object)"write result to file initializeSchema.sql");
        boolean writen = WriteFileExtensions.writeStringToFile((File)initializeSchemaDdl, (String)sb.toString(), (String)this.fileEncoding);
        LOG.debug((Object)"end process of creation of initializeSchema.sql file.");
        return writen;
    }

    protected void createSchema(Connection jdbcConnection, String processtype) throws FileNotFoundException, IOException, SQLException {
        this.initializeScriptFiles();
        boolean writen = this.createInitializationScript(processtype);
        if (writen) {
            LOG.debug((Object)"write process of file initializeSchema.sql is finished");
        }
        this.createSchemaFromScript(jdbcConnection);
    }

    protected void createSchemaFromScript(Connection jdbcConnection) throws IOException, SQLException {
        LOG.debug((Object)"creating database schema from script");
        File insertsDir = this.getInsertDir();
        File initializeSchemaDdl = new File(insertsDir, "initializeSchema.sql");
        String result = ReadFileExtensions.readFromFile((File)initializeSchemaDdl);
        ConnectionsExtensions.executeSqlScript((Connection)jdbcConnection, (String)result, (boolean)this.log);
    }

    protected void deleteAndCreateEmptyDatabaseWithoutTables() throws ClassNotFoundException, SQLException {
        ConnectionsExtensions.dropPostgreSQLDatabase((String)this.host, (String)this.databaseName, (String)this.databaseUser, (String)this.databasePassword);
        this.newEmptyDatabaseWithoutTables();
    }

    protected void dropTablesAndSequences(Connection jdbcConnection) throws IOException, SQLException {
        File projectDir = PathFinder.getProjectDirectory();
        File dropSchemaSqlFile = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"src/main/resources/dll", (String)"dropSchema.sql");
        if (!dropSchemaSqlFile.exists()) {
            CreateFileExtensions.newFileQuietly((File)dropSchemaSqlFile);
        }
        ConnectionsExtensions.executeSqlScript((BufferedReader)((BufferedReader)StreamExtensions.getReader((File)dropSchemaSqlFile, (String)this.fileEncoding, (boolean)false)), (Connection)jdbcConnection, (boolean)this.log);
    }

    public Properties getDatabaseProperties() {
        return this.databaseProperties;
    }

    protected File getInsertDir() {
        File insertsDir = new File(this.getSqlDir(), "inserts");
        return insertsDir;
    }

    protected String getProcessType() {
        String arg;
        String processtype = DROP_PROCESS;
        if (this.initializationProcess != null && ((arg = this.initializationProcess).equals(DELETE_PROCESS) || arg.equals(DROP_PROCESS) || arg.equals(CREATE_PROCESS) || arg.equals(CREATE_EMPTY_PROCESS))) {
            processtype = arg;
        }
        return processtype;
    }

    protected abstract List<File> getScriptFiles();

    protected File getSqlDir() {
        File resDestDir = PathFinder.getSrcMainResourcesDir();
        File sqlDir = new File(resDestDir, "dll");
        return sqlDir;
    }

    public void initializeDatabase() throws ClassNotFoundException, SQLException, IOException {
        LOG.debug((Object)"Initialize database started...");
        String processtype = this.getProcessType();
        LOG.debug((Object)("with processtype " + processtype));
        boolean dbExists = ConnectionsExtensions.existsPostgreSQLDatabase((String)this.host, (String)this.databaseName, (String)this.databaseUser, (String)this.databasePassword);
        if (!dbExists) {
            LOG.debug((Object)"database does not exists");
            this.newEmptyDatabaseWithoutTables();
        }
        if (!processtype.equals(CREATE_EMPTY_PROCESS)) {
            if (processtype.equals(DELETE_PROCESS)) {
                LOG.debug((Object)"delete and create empty database without tables");
                this.deleteAndCreateEmptyDatabaseWithoutTables();
            }
            LOG.debug((Object)"Get jdbc connection to database");
            try (Connection jdbcConnection = ConnectionsExtensions.getPostgreSQLConnection((String)this.host, (String)this.databaseName, (String)this.databaseUser, (String)this.databasePassword);){
                if (processtype.equals(DROP_PROCESS)) {
                    LOG.debug((Object)"drop database schema");
                    this.dropTablesAndSequences(jdbcConnection);
                }
                LOG.debug((Object)"create database schema");
                this.createSchema(jdbcConnection, processtype);
                LOG.debug((Object)"initialize database with some data");
                this.initializeDatabase(jdbcConnection);
            }
        }
    }

    protected void initializeDatabase(Connection jdbcConnection) throws IOException, SQLException {
        List<File> scriptFiles = this.getScriptFiles();
        int size = scriptFiles.size();
        for (int i = 0; i < size; ++i) {
            ConnectionsExtensions.executeSqlScript((BufferedReader)((BufferedReader)StreamExtensions.getReader((File)scriptFiles.get(i), (String)this.fileEncoding, (boolean)false)), (Connection)jdbcConnection, (boolean)this.log);
        }
    }

    protected void initializeScriptFiles() throws FileNotFoundException, IOException {
        File projectDir = PathFinder.getProjectDirectory();
        File schemaDllDir = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"target/hibernate3/sql", (String)"schema.ddl");
        if (schemaDllDir.exists()) {
            File schemaSqlDir = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"src/main/resources/dll", (String)"schema.sql");
            File dropSchemaSqlDir = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"src/main/resources/dll", (String)"dropSchema.sql");
            File createIndexesAndForeignKeys = PathFinder.getRelativePathTo((File)projectDir, (String)"/", (String)"src/main/resources/dll", (String)"createIndexesAndForeignKeys.sql");
            List lines = ReadFileExtensions.readLinesInList((File)schemaDllDir);
            ArrayList<String> dropTables = new ArrayList<String>();
            ArrayList<String> createTables = new ArrayList<String>();
            ArrayList<String> createIndexesAndAlterTable = new ArrayList<String>();
            for (String currentLine : lines) {
                if (currentLine.startsWith("alter table") && currentLine.contains("drop constraint")) {
                    dropTables.add(currentLine);
                    continue;
                }
                if (currentLine.startsWith("drop ")) {
                    dropTables.add(currentLine);
                    continue;
                }
                if (currentLine.startsWith("create table")) {
                    createTables.add(currentLine);
                }
                if (!currentLine.startsWith("create index") && !currentLine.startsWith("alter table") && !currentLine.startsWith("create sequence")) continue;
                createIndexesAndAlterTable.add(currentLine);
            }
            WriteFileExtensions.writeLinesToFile(dropTables, (File)dropSchemaSqlDir, (String)"UTF-8");
            WriteFileExtensions.writeLinesToFile(createTables, (File)schemaSqlDir, (String)"UTF-8");
            WriteFileExtensions.writeLinesToFile(createIndexesAndAlterTable, (File)createIndexesAndForeignKeys, (String)"UTF-8");
        }
    }

    protected void newEmptyDatabaseWithoutTables() throws ClassNotFoundException, SQLException {
        ConnectionsExtensions.newPostgreSQLDatabase((String)this.host, (String)this.databaseName, (String)this.databaseUser, (String)this.databasePassword, null, null);
    }

    protected String replaceMediumblobToBytea(File schema) throws IOException {
        String contentSchema = ReadFileExtensions.readFromFile((File)schema);
        String result = StringUtils.replace((String)contentSchema, (String)"MEDIUMBLOB", (String)"BYTEA");
        WriteFileExtensions.writeStringToFile((File)schema, (String)result, (String)"UTF-8");
        return result;
    }
}

