/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.springconfig;

import de.alpharogroup.collections.CollectionExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JdbcUrlBean {
    public static final JdbcUrlBean DEFAULT_MYSQL_URL = JdbcUrlBean.builder().protocol("jdbc:mysql://").host("localhost").port(3306).build();
    public static final JdbcUrlBean DEFAULT_POSTGRESQL_URL = JdbcUrlBean.builder().protocol("jdbc:postgresql://").host("localhost").port(5432).build();
    private String database;
    private String host;
    private List<String> parameters;
    private int port;
    private String protocol;

    public static String newDefaultMysqlJdbcUrl(String database) {
        return JdbcUrlBean.newMysqlJdbcUrl(DEFAULT_MYSQL_URL.toBuilder().database(database).build());
    }

    public static String newDefaultPostgresJdbcUrl(String database) {
        return JdbcUrlBean.newPostgresJdbcUrl(DEFAULT_POSTGRESQL_URL.toBuilder().database(database).build());
    }

    public static String newH2JdbcUrl(JdbcUrlBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getProtocol()).append(bean.getDatabase());
        if (CollectionExtensions.isNotEmpty(bean.getParameters())) {
            for (String parameter : bean.getParameters()) {
                sb.append(";").append(parameter);
            }
        }
        return sb.toString();
    }

    public static String newMysqlJdbcUrl(JdbcUrlBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getProtocol()).append(bean.getHost()).append(":").append(bean.getPort()).append("/").append(bean.getDatabase());
        return sb.toString();
    }

    public static String newPostgresJdbcUrl(JdbcUrlBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getProtocol()).append(bean.getHost()).append(":").append(bean.getPort()).append("/").append(bean.getDatabase());
        return sb.toString();
    }

    public static JdbcUrlBeanBuilder builder() {
        return new JdbcUrlBeanBuilder();
    }

    public JdbcUrlBeanBuilder toBuilder() {
        JdbcUrlBeanBuilder builder = new JdbcUrlBeanBuilder().database(this.database).host(this.host).port(this.port).protocol(this.protocol);
        if (this.parameters != null) {
            builder.parameters(this.parameters);
        }
        return builder;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getHost() {
        return this.host;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcUrlBean)) {
            return false;
        }
        JdbcUrlBean other = (JdbcUrlBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        List<String> this$parameters = this.getParameters();
        List<String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcUrlBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        List<String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        result = result * 59 + this.getPort();
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcUrlBean(database=" + this.getDatabase() + ", host=" + this.getHost() + ", parameters=" + this.getParameters() + ", port=" + this.getPort() + ", protocol=" + this.getProtocol() + ")";
    }

    public JdbcUrlBean() {
    }

    public JdbcUrlBean(String database, String host, List<String> parameters, int port, String protocol) {
        this.database = database;
        this.host = host;
        this.parameters = parameters;
        this.port = port;
        this.protocol = protocol;
    }

    public static class JdbcUrlBeanBuilder {
        private String database;
        private String host;
        private ArrayList<String> parameters;
        private int port;
        private String protocol;

        JdbcUrlBeanBuilder() {
        }

        public JdbcUrlBeanBuilder database(String database) {
            this.database = database;
            return this;
        }

        public JdbcUrlBeanBuilder host(String host) {
            this.host = host;
            return this;
        }

        public JdbcUrlBeanBuilder parameter(String parameter) {
            if (this.parameters == null) {
                this.parameters = new ArrayList();
            }
            this.parameters.add(parameter);
            return this;
        }

        public JdbcUrlBeanBuilder parameters(Collection<? extends String> parameters) {
            if (this.parameters == null) {
                this.parameters = new ArrayList();
            }
            this.parameters.addAll(parameters);
            return this;
        }

        public JdbcUrlBeanBuilder clearParameters() {
            if (this.parameters != null) {
                this.parameters.clear();
            }
            return this;
        }

        public JdbcUrlBeanBuilder port(int port) {
            this.port = port;
            return this;
        }

        public JdbcUrlBeanBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public JdbcUrlBean build() {
            List<String> parameters;
            switch (this.parameters == null ? 0 : this.parameters.size()) {
                case 0: {
                    parameters = Collections.emptyList();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonList(this.parameters.get(0));
                    break;
                }
                default: {
                    parameters = Collections.unmodifiableList(new ArrayList<String>(this.parameters));
                }
            }
            return new JdbcUrlBean(this.database, this.host, parameters, this.port, this.protocol);
        }

        public String toString() {
            return "JdbcUrlBean.JdbcUrlBeanBuilder(database=" + this.database + ", host=" + this.host + ", parameters=" + this.parameters + ", port=" + this.port + ", protocol=" + this.protocol + ")";
        }
    }
}

