/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.service.domain;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import de.alpharogroup.merge.object.MergeObjectExtensions;
import de.alpharogroup.service.domain.DomainService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class AbstractDomainService<PK extends Serializable, DO extends DomainObject<PK>, E extends BaseEntity<PK>, DAO extends EntityManagerDao<E, PK>, M extends EntityDOMapper<E, DO>>
implements DomainService<PK, DO> {
    private DAO dao;
    private M mapper;
    private final Class<E> entityClass = TypeArgumentsExtensions.getTypeArgument(AbstractDomainService.class, this.getClass(), (int)2);
    private final Class<DO> domainObjectClass = TypeArgumentsExtensions.getTypeArgument(AbstractDomainService.class, this.getClass(), (int)1);

    @Override
    @Transactional
    public DO create(DO domainObject) {
        Object entity = this.getMapper().toEntity(domainObject);
        entity = this.dao.merge(entity);
        domainObject.setId((Serializable)entity.getId());
        return domainObject;
    }

    @Override
    @Transactional
    public DO delete(PK id) {
        BaseEntity entity = this.dao.get(id);
        Object domainObject = this.getMapper().toDomainObject((BaseEntity)entity);
        this.dao.delete(id);
        return domainObject;
    }

    @Override
    public boolean exists(PK id) {
        return this.dao.exists(id);
    }

    @Override
    public List<DO> findAll() {
        List all = this.dao.findAll();
        ArrayList domainObjects = new ArrayList();
        for (BaseEntity entity : all) {
            domainObjects.add(this.getMapper().toDomainObject((BaseEntity)entity));
        }
        return domainObjects;
    }

    @Override
    @Transactional
    public Collection<PK> persist(Collection<DO> domainObjects) {
        ArrayList primaryKeys = new ArrayList();
        for (DomainObject domainObject : domainObjects) {
            primaryKeys.add(this.create(domainObject).getId());
        }
        return primaryKeys;
    }

    @Override
    public DO read(PK id) {
        BaseEntity entity = this.dao.get(id);
        Object domainObject = this.getMapper().toDomainObject((BaseEntity)entity);
        return domainObject;
    }

    @Override
    @Transactional
    public DO update(DO domainObject) {
        BaseEntity entity = this.dao.get((Serializable)domainObject.getId());
        MergeObjectExtensions.mergeOrCopyQuietly((Object)entity, domainObject);
        entity = this.dao.merge(entity);
        return domainObject;
    }

    public void setDao(DAO dao) {
        this.dao = dao;
    }

    public DAO getDao() {
        return this.dao;
    }

    public void setMapper(M mapper) {
        this.mapper = mapper;
    }

    public M getMapper() {
        return this.mapper;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public Class<DO> getDomainObjectClass() {
        return this.domainObjectClass;
    }
}

