/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.service.domain;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityBOMapper;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.lang.TypeArgumentsUtils;
import de.alpharogroup.service.domain.DomainService;
import java.io.Serializable;

public abstract class AbstractDomainService<PK extends Serializable, BO extends DomainObject<PK>, E extends BaseEntity<PK>, DAO extends EntityManagerDao<E, PK>, M extends EntityBOMapper<E, BO>>
implements DomainService<PK, BO> {
    private DAO dao;
    private M mapper;
    private final Class<E> entityClass = TypeArgumentsUtils.getTypeArgument(AbstractDomainService.class, this.getClass(), (int)2);
    private final Class<BO> domainObjectClass = TypeArgumentsUtils.getTypeArgument(AbstractDomainService.class, this.getClass(), (int)1);

    @Override
    public BO read(PK id) {
        BaseEntity entity = this.dao.get(id);
        return this.getMapper().toDomainObject((BaseEntity)entity);
    }

    @Override
    public BO create(BO domainObject) {
        Object entity = this.getMapper().toEntity(domainObject);
        domainObject.setId((Serializable)this.dao.save(entity));
        return domainObject;
    }

    @Override
    public void update(BO domainObject) {
        BaseEntity entity = this.dao.get((Serializable)domainObject.getId());
        ObjectExtensions.copyQuietly((Object)entity, domainObject);
        this.dao.merge(entity);
    }

    @Override
    public void delete(PK id) {
        this.dao.delete(id);
    }

    public void setDao(DAO dao) {
        this.dao = dao;
    }

    public DAO getDao() {
        return this.dao;
    }

    public void setMapper(M mapper) {
        this.mapper = mapper;
    }

    public M getMapper() {
        return this.mapper;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public Class<BO> getDomainObjectClass() {
        return this.domainObjectClass;
    }
}

