/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.entitymapper;

import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.domain.DomainObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dozer.Mapper;
import org.dozer.MappingException;

public interface EntityBOMapper<E extends BaseEntity<?>, BO extends DomainObject<?>> {
    public Mapper getMapper();

    public Class<BO> getDomainObjectClass();

    public Class<E> getEntityClass();

    default public BO toDomainObject(E entity) {
        if (entity != null) {
            return (BO)((DomainObject)this.getMapper().map(entity, this.getDomainObjectClass()));
        }
        return null;
    }

    default public List<BO> toDomainObjects(Collection<E> entities) {
        ArrayList<BO> domainObjects = new ArrayList<BO>();
        if (entities != null && !entities.isEmpty()) {
            for (BaseEntity entity : entities) {
                domainObjects.add(this.toDomainObject(entity));
            }
        }
        return domainObjects;
    }

    default public List<E> toEntities(Collection<BO> domainObjects) {
        ArrayList<E> entities = new ArrayList<E>();
        if (domainObjects != null && !domainObjects.isEmpty()) {
            for (DomainObject domainObject : domainObjects) {
                entities.add(this.toEntity(domainObject));
            }
        }
        return entities;
    }

    default public E toEntity(BO domainObject) {
        if (domainObject != null) {
            return (E)((BaseEntity)this.getMapper().map(domainObject, this.getEntityClass()));
        }
        return null;
    }

    default public <T, S> T map(S source, Class<T> destinationClass) throws MappingException {
        return (T)this.getMapper().map(source, destinationClass);
    }

    default public <T, S> List<T> map(Collection<S> sources, Class<T> destinationClass) throws MappingException {
        ArrayList<T> destination = new ArrayList<T>();
        if (sources != null && !sources.isEmpty()) {
            for (S source : sources) {
                destination.add(this.map(source, destinationClass));
            }
        }
        return destination;
    }
}

