/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.entitymapper;

import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.MapperExtensions;
import de.alpharogroup.domain.DomainObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dozer.Mapper;
import org.dozer.MappingException;

public interface EntityDOMapper<E extends BaseEntity<?>, DO extends DomainObject<?>> {
    public Class<DO> getDomainObjectClass();

    public Class<E> getEntityClass();

    public Mapper getMapper();

    default public <T, S> List<T> map(Collection<S> sources, Class<T> destinationClass) throws MappingException {
        return MapperExtensions.map(this.getMapper(), sources, destinationClass);
    }

    default public <T, S> T map(S source, Class<T> destinationClass) throws MappingException {
        return MapperExtensions.map(this.getMapper(), source, destinationClass);
    }

    default public DO toDomainObject(E entity) {
        if (entity != null) {
            return (DO)((DomainObject)this.getMapper().map(entity, this.getDomainObjectClass()));
        }
        return null;
    }

    default public List<DO> toDomainObjects(Collection<E> entities) {
        ArrayList<DO> domainObjects = new ArrayList<DO>();
        if (entities != null && !entities.isEmpty()) {
            for (BaseEntity entity : entities) {
                domainObjects.add(this.toDomainObject(entity));
            }
        }
        return domainObjects;
    }

    default public List<E> toEntities(Collection<DO> domainObjects) {
        ArrayList<E> entities = new ArrayList<E>();
        if (domainObjects != null && !domainObjects.isEmpty()) {
            for (DomainObject domainObject : domainObjects) {
                entities.add(this.toEntity(domainObject));
            }
        }
        return entities;
    }

    default public E toEntity(DO domainObject) {
        if (domainObject != null) {
            return (E)((BaseEntity)this.getMapper().map(domainObject, this.getEntityClass()));
        }
        return null;
    }
}

