/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.email.send;

import de.alpharogroup.email.messages.EmailMessage;
import de.alpharogroup.email.messages.EmailMessageWithAttachments;
import de.alpharogroup.email.send.SendMail;
import de.alpharogroup.email.utils.EmailExtensions;
import de.alpharogroup.resourcebundle.properties.PropertiesExtensions;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;

public class SendEmail
implements SendMail {
    private boolean debug;
    private Properties properties;
    private Session session;
    private Authenticator authenticator;

    public SendEmail() {
        this.loadProperties();
    }

    public SendEmail(Properties properties) {
        this.properties = properties;
    }

    public SendEmail(Properties properties, Authenticator authenticator) {
        this.properties = properties;
        this.authenticator = authenticator;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public synchronized Session getSession() {
        if (this.session == null) {
            this.session = this.authenticator != null ? Session.getInstance((Properties)this.properties, (Authenticator)this.authenticator) : Session.getInstance((Properties)this.properties);
        }
        return this.session;
    }

    private void loadProperties() {
        this.properties = PropertiesExtensions.loadProperties((Object)this, (String)"mail.properties");
    }

    @Override
    public String sendEmail(String to, String from, String subject, String message) throws AddressException, UnsupportedEncodingException, MessagingException {
        String messageId = null;
        Address[] fromAddress = EmailExtensions.getAddressArray(EmailExtensions.newAddress(from, null));
        Address toAddress = EmailExtensions.newAddress(to, null, null);
        EmailMessage email = new EmailMessage();
        email.addFrom(fromAddress);
        email.addTo(toAddress);
        email.setSubject(subject);
        email.setContent(message, "text/plain");
        messageId = this.sendEmailMessage(email);
        return messageId;
    }

    @Override
    public String sendEmailMessage(EmailMessage emailMessage) throws MessagingException {
        Transport.send((Message)emailMessage);
        return emailMessage.getMessageID();
    }

    @Override
    public Collection<String> sendEmailMessages(Collection<EmailMessage> emailMessages) throws MessagingException {
        ArrayList<String> messageIds = new ArrayList<String>();
        for (EmailMessage emailMessage : emailMessages) {
            String messageId = this.sendEmailMessage(emailMessage);
            messageIds.add(messageId);
        }
        return messageIds;
    }

    @Override
    public Collection<String> sendEmailMessagesWithAtachments(Collection<EmailMessageWithAttachments> emailAttachments) throws MessagingException {
        ArrayList<String> messageIds = new ArrayList<String>();
        for (EmailMessageWithAttachments emailAttachment : emailAttachments) {
            String messageId = this.sendEmailMessageWithAttachments(emailAttachment);
            messageIds.add(messageId);
        }
        return messageIds;
    }

    @Override
    public String sendEmailMessageWithAttachments(EmailMessageWithAttachments emailAttachments) throws MessagingException {
        return this.sendEmailMessage(emailAttachments.getEmailMessage());
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
        this.getSession().setDebug(debug);
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }
}

