/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.email.utils;

import de.alpharogroup.email.messages.EmailMessage;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.string.StringExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class EmailExtensions {
    public static EmailMessage addToRecipientToEmailMessage(String recipientEmail, String recipientPersonal, String recipientCharset, EmailMessage emailMessage) throws UnsupportedEncodingException, MessagingException {
        Address recipientAddress = EmailExtensions.newAddress(recipientEmail, recipientPersonal, recipientCharset);
        if (null != recipientAddress) {
            emailMessage.addTo(recipientAddress);
        } else {
            emailMessage.setRecipients(Message.RecipientType.TO, recipientEmail);
        }
        return emailMessage;
    }

    public static Address[] getAddressArray(Address ... address) {
        return address;
    }

    public static String getCharsetFromContentType(String type) throws MessagingException {
        int start;
        if (!StringExtensions.isNullOrEmpty((String)type) && (start = type.indexOf("; charset=")) > 0) {
            int offset = type.indexOf(" ", start += "; charset=".length());
            if (offset > 0) {
                return type.substring(start, offset);
            }
            return type.substring(start);
        }
        return null;
    }

    public static String getString(DataHandler dataHandler) throws IOException {
        if (dataHandler != null) {
            InputStream input = dataHandler.getDataSource().getInputStream();
            byte[] data = ReadFileExtensions.toByteArray((InputStream)input);
            return Base64.getEncoder().encodeToString(data);
        }
        return "";
    }

    public static Address newAddress(String address) throws AddressException, UnsupportedEncodingException {
        return EmailExtensions.newAddress(address, null, null);
    }

    public static Address newAddress(String emailAddress, String personal) throws AddressException, UnsupportedEncodingException {
        return EmailExtensions.newAddress(emailAddress, personal, null);
    }

    public static Address newAddress(String address, String personal, String charset) throws AddressException, UnsupportedEncodingException {
        if (StringExtensions.isNullOrEmpty((String)personal)) {
            personal = address;
        }
        InternetAddress internetAdress = new InternetAddress(address);
        if (StringExtensions.isNullOrEmpty((String)charset)) {
            internetAdress.setPersonal(personal);
        } else {
            internetAdress.setPersonal(personal, charset);
        }
        return internetAdress;
    }

    public static EmailMessage setFromToEmailMessage(String senderEmail, String senderPersonal, String senderCharset, EmailMessage emailMessage) throws UnsupportedEncodingException, MessagingException {
        Address senderAddress = null;
        senderAddress = EmailExtensions.newAddress(senderEmail, senderPersonal, senderCharset);
        if (null != senderAddress) {
            emailMessage.setFrom(senderAddress);
        } else {
            emailMessage.setFrom(senderEmail);
        }
        return emailMessage;
    }

    public static boolean validateEmailAdress(String emailAddress) {
        boolean isValid = true;
        try {
            InternetAddress internetAddress = new InternetAddress(emailAddress);
            internetAddress.validate();
        }
        catch (AddressException e) {
            isValid = false;
        }
        return isValid;
    }
}

