/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.email.messages;

import de.alpharogroup.email.utils.EmailExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;

public class EmailMessage
extends MimeMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String charset;

    public EmailMessage() {
        this(null);
    }

    public EmailMessage(Session session) {
        super(session);
    }

    public void addBcc(Address internetAddress) throws MessagingException {
        super.addRecipient(Message.RecipientType.BCC, internetAddress);
    }

    public void addCc(Address internetAddress) throws MessagingException {
        super.addRecipient(Message.RecipientType.CC, internetAddress);
    }

    public void addFrom(Address internetAddress) throws MessagingException {
        super.addFrom(EmailExtensions.getAddressArray(internetAddress));
    }

    public void addTo(Address internetAddress) throws MessagingException {
        super.addRecipient(Message.RecipientType.TO, internetAddress);
    }

    protected Object clone() throws CloneNotSupportedException {
        EmailMessage cloned = new EmailMessage();
        try {
            cloned.setExpunged(this.expunged);
            cloned.setMessageNumber(this.getMessageNumber());
            cloned.setContent(this.getContent(), this.getContentType());
            if (this.getContentID() != null) {
                cloned.setContentID(this.getContentID());
            }
            if (this.getContentLanguage() != null) {
                cloned.setContentLanguage(this.getContentLanguage());
            }
            if (this.getContentMD5() != null) {
                cloned.setContentMD5(this.getContentMD5());
            }
            if (this.getDataHandler() != null) {
                cloned.setDataHandler(this.getDataHandler());
            }
            if (this.getFileName() != null) {
                cloned.setFileName(this.getFileName());
            }
            if (this.getFlags() != null) {
                cloned.setFlags(this.getFlags(), true);
            }
            if (this.getFrom() != null) {
                Address[] fromAddresses;
                for (Address fromAddresse : fromAddresses = this.getFrom()) {
                    cloned.setFrom(fromAddresse);
                }
            }
            Enumeration enumeration = this.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                String line = (String)enumeration.nextElement();
                cloned.addHeaderLine(line);
            }
            if (this.getRecipients(Message.RecipientType.TO) != null) {
                Address[] toAddresses = this.getRecipients(Message.RecipientType.TO);
                cloned.setRecipients(Message.RecipientType.TO, toAddresses);
            }
            if (this.getRecipients(Message.RecipientType.CC) != null) {
                Address[] ccAddresses = this.getRecipients(Message.RecipientType.CC);
                cloned.setRecipients(Message.RecipientType.CC, ccAddresses);
            }
            if (this.getRecipients(Message.RecipientType.BCC) != null) {
                Address[] bccAddresses = this.getRecipients(Message.RecipientType.BCC);
                cloned.setRecipients(Message.RecipientType.BCC, bccAddresses);
            }
            if (this.getReplyTo() != null) {
                Address[] replyToAddresses = this.getReplyTo();
                cloned.setReplyTo(replyToAddresses);
            }
            if (this.getSender() != null) {
                cloned.setSender(this.getSender());
            }
            if (this.getSentDate() != null) {
                cloned.setSentDate(this.getSentDate());
            }
            if (this.getCharset() != null) {
                if (this.getSubject() != null) {
                    cloned.setSubject(this.getSubject(), this.getCharset());
                }
                if (this.getDescription() != null) {
                    cloned.setDescription(this.getDescription(), this.getCharset());
                }
            } else {
                if (this.getSubject() != null) {
                    cloned.setSubject(this.getSubject());
                }
                if (this.getDescription() != null) {
                    cloned.setDescription(this.getDescription());
                }
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmailMessage other = (EmailMessage)obj;
        return !(this.charset == null ? other.charset != null : !this.charset.equals(other.charset));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        return result;
    }

    public void setContent(Object content, String type) throws MessagingException {
        this.charset = EmailExtensions.getCharsetFromContentType(type);
        super.setContent(content, type);
    }

    public void setFrom(String senderEmail) throws AddressException, UnsupportedEncodingException, MessagingException {
        Address fromEmail = EmailExtensions.newAddress(senderEmail);
        super.setFrom(fromEmail);
    }

    public void setSubject(String subject) throws MessagingException {
        if (this.charset == null) {
            super.setSubject(subject);
            return;
        }
        this.setSubject(subject, this.charset);
    }

    public void setSubject(String subject, String charset) throws MessagingException {
        super.setSubject(subject, charset);
    }

    public void setUtf8Content(Object content) throws MessagingException {
        String type = "text/plain; charset=UTF-8";
        this.setContent(content, "text/plain; charset=UTF-8");
    }

    public String getCharset() {
        return this.charset;
    }
}

