/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.dtd.to.xsd;

import de.alpharogroup.dtd.to.xsd.type.TypePattern;
import de.alpharogroup.dtd.to.xsd.writer.Writer;
import de.alpharogroup.io.StreamExtensions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;

public final class Converter {
    public static File convert(File dtdfile, File xsdfile) {
        FileOutputStream outStream = null;
        if (xsdfile != null) {
            try {
                outStream = new FileOutputStream(xsdfile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
            }
        }
        Writer writer = new Writer();
        writer.setOutStream(outStream);
        try {
            writer.parse(new XMLInputSource(null, dtdfile.getAbsolutePath(), null));
        }
        catch (XNIException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xsdfile;
    }

    public static File convert(String dtdfile, File xsdfile) {
        FileOutputStream outStream = null;
        if (xsdfile != null) {
            try {
                outStream = new FileOutputStream(xsdfile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
            }
        }
        Writer writer = new Writer();
        writer.setOutStream(outStream);
        try {
            writer.parse(new XMLInputSource(null, dtdfile, null));
        }
        catch (XNIException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xsdfile;
    }

    public static void convert(String targetNamespace, List<TypePattern> listXsdTypePattern, String dtdfile, File xsdfile) {
        FileOutputStream outStream = null;
        if (xsdfile != null) {
            try {
                outStream = new FileOutputStream(xsdfile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
                return;
            }
        }
        Writer writer = new Writer();
        writer.setTargetNamespace(targetNamespace);
        writer.addXsdTypePattern(listXsdTypePattern);
        writer.setOutStream(outStream);
        try {
            writer.parse(new XMLInputSource(null, dtdfile, null));
        }
        catch (XNIException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String targetNamespace, List<TypePattern> listXsdTypePattern, String dtdfile, String xsdfile) {
        OutputStream outStream = null;
        if (xsdfile != null) {
            try {
                outStream = new FileOutputStream(xsdfile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
                return;
            }
            finally {
                StreamExtensions.closeOutputStream((OutputStream)outStream);
            }
        }
        outStream = System.out;
        Writer writer = new Writer();
        writer.setTargetNamespace(targetNamespace);
        writer.addXsdTypePattern(listXsdTypePattern);
        writer.setOutStream(outStream);
        try {
            writer.parse(new XMLInputSource(null, dtdfile, null));
        }
        catch (XNIException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convert(String dtdfile, String xsdfile) {
        FileOutputStream outStream = null;
        if (xsdfile != null) {
            try {
                outStream = new FileOutputStream(xsdfile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
                return;
            }
        }
        Writer writer = new Writer();
        writer.setOutStream(outStream);
        try {
            writer.parse(new XMLInputSource(null, dtdfile, null));
        }
        catch (XNIException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Converter() {
    }
}

