/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.dtd.to.xsd.parser;

import de.alpharogroup.dtd.to.xsd.type.TypePattern;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.parsers.XMLDocumentParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class Parser
extends XMLDocumentParser
implements XMLDTDHandler,
XMLDTDContentModelHandler,
XMLErrorHandler {
    private static final String XSD_SCHEMA = "xsd:schema";
    private static final String HTTP_WWW_W3_ORG_2001_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String FORMAT_PRETTY_PRINT = "format-pretty-print";
    private static final String UTF_8 = "UTF-8";
    private static final String ATTRIBUTE_PUBLIC = "public";
    private static final String XSD_NOTATION_LOWERCASE = "xsd:notation";
    private static final String PCDATA = "PCDATA";
    private static final String XSD_CHOICE = "xsd:choice";
    private static final String XSD_SEQUENCE = "xsd:sequence";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String OPTIONAL = "optional";
    private static final String ATTRIBUTE_FIXED = "fixed";
    private static final String FIXED_TYPE = "#FIXED";
    private static final String REQUIRED = "required";
    private static final String USE = "use";
    private static final String REQUIRED_TYPE = "#REQUIRED";
    private static final String XSD_SIMPLE_TYPE = "xsd:simpleType";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String XSD_ENUMERATION = "xsd:enumeration";
    private static final String BASE = "base";
    private static final String XSD_RESTRICTION = "xsd:restriction";
    private static final String ENUMERATION_TYPE = "ENUMERATION";
    private static final String NAME = "name";
    private static final String XSD_ATTRIBUTE = "xsd:attribute";
    private static final String MAX_OCCURS = "maxOccurs";
    private static final String MIN_OCCURS = "minOccurs";
    private static final String ATTRIBUTE_REF = "ref";
    private static final String XSD_ELEMENT = "xsd:element";
    private static final String MIXED = "mixed";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String XSD_COMPLEX_TYPE = "xsd:complexType";
    private static final String XSD_NOTATION = "xsd:NOTATION";
    private static final String XSD_NMTOKENS = "xsd:NMTOKENS";
    private static final String XSD_NMTOKEN = "xsd:NMTOKEN";
    private static final String XSD_ENTITIES = "xsd:ENTITIES";
    private static final String XSD_ENTITY = "xsd:ENTITY";
    private static final String XSD_IDREFS = "xsd:IDREFS";
    private static final String XSD_STRING = "xsd:string";
    private static final String XSD_IDREF = "xsd:IDREF";
    private static final String XSD_ID = "xsd:ID";
    private static final String DTD_NOTATION = "NOTATION";
    private static final String DTD_ENTITIES = "ENTITIES";
    private static final String DTD_ENTITY = "ENTITY";
    private static final String DTD_NMTOKENS = "NMTOKENS";
    private static final String DTD_NMTOKEN = "NMTOKEN";
    private static final String DTD_IDREFS = "IDREFS";
    private static final String DTD_IDREF = "IDREF";
    private static final String DTD_ID = "ID";
    private static final String DTD_CDATA = "CDATA";
    private static final Logger log = Logger.getLogger((String)"Parser");
    private String type = "";
    private CoreDOMImplementationImpl domImpl;
    private Document doc;
    private Element root;
    private final Stack<Element> stackElements;
    private String targetNamespace;
    private final HashSet<String> setXmlResourceIdentifier;
    private boolean hasParsed = false;
    private final Stack<Boolean> parsedStack;
    private int groupDepth = 0;
    private final List<Short> listGroupTypes;
    private final List<List<Element>> listGroupElements;
    private final Map<String, Element> allElements;
    private final Map<String, String> dataTypeMap;
    private final List<TypePattern> listXsdTypePattern;

    public Parser(XMLParserConfiguration configuration) {
        super(configuration);
        configuration.setErrorHandler((XMLErrorHandler)this);
        this.dataTypeMap = new HashMap<String, String>();
        this.dataTypeMap.put(DTD_ID, XSD_ID);
        this.dataTypeMap.put(DTD_IDREF, XSD_IDREF);
        this.dataTypeMap.put(DTD_CDATA, XSD_STRING);
        this.dataTypeMap.put(DTD_IDREFS, XSD_IDREFS);
        this.dataTypeMap.put(DTD_ENTITY, XSD_ENTITY);
        this.dataTypeMap.put(DTD_ENTITIES, XSD_ENTITIES);
        this.dataTypeMap.put(DTD_NMTOKEN, XSD_NMTOKEN);
        this.dataTypeMap.put(DTD_NMTOKENS, XSD_NMTOKENS);
        this.dataTypeMap.put(DTD_NOTATION, XSD_NOTATION);
        this.allElements = new HashMap<String, Element>();
        this.setXmlResourceIdentifier = new HashSet();
        this.listGroupTypes = new ArrayList<Short>();
        this.listGroupElements = new ArrayList<List<Element>>();
        this.listXsdTypePattern = new ArrayList<TypePattern>();
        this.parsedStack = new Stack();
        this.stackElements = new Stack();
    }

    public void addXsdTypePattern(List<TypePattern> list) {
        this.listXsdTypePattern.addAll(list);
    }

    public void addXsdTypePattern(TypePattern xsdTypePattern) {
        this.listXsdTypePattern.add(xsdTypePattern);
    }

    public void any(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void attributeDecl(String ename, String aname, String atype, String[] enums, String dtype, XMLString dvalue, XMLString nondvalue, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        Element attr = this.newAttribute(ename, aname, atype, enums, dtype, dvalue, nondvalue, augs);
        Element element = this.allElements.get(ename);
        if (element != null) {
            if (element.getChildNodes().getLength() > 0) {
                Element child = (Element)element.getChildNodes().item(0);
                child.appendChild(attr);
            } else {
                Element complexType = this.doc.createElement(XSD_COMPLEX_TYPE);
                element.appendChild(complexType);
                complexType.appendChild(attr);
                if (XSD_STRING.equals(element.getAttribute(ATTRIBUTE_TYPE))) {
                    complexType.setAttribute(MIXED, "true");
                }
                element.removeAttribute(ATTRIBUTE_TYPE);
            }
        }
    }

    private List<Element> combineSequenceList(List<Element> listElement) {
        boolean needCombin = false;
        int i = 0;
        LinkedHashMap mapRefList = new LinkedHashMap();
        for (Element element : listElement) {
            if (XSD_ELEMENT.equals(element.getTagName())) {
                String ref = element.getAttribute(ATTRIBUTE_REF);
                ArrayList<Element> reflist = (ArrayList<Element>)mapRefList.get(ref);
                if (reflist == null) {
                    reflist = new ArrayList<Element>(1);
                    reflist.add(element);
                    mapRefList.put(ref, reflist);
                    continue;
                }
                reflist.add(element);
                needCombin = true;
                continue;
            }
            ArrayList<Element> reflist = new ArrayList<Element>(1);
            reflist.add(element);
            mapRefList.put(element.getTagName() + i, reflist);
            ++i;
        }
        if (!needCombin) {
            return listElement;
        }
        ArrayList<Element> returnList = new ArrayList<Element>();
        for (List refList : mapRefList.values()) {
            if (refList.size() == 1) {
                returnList.add((Element)refList.get(0));
                continue;
            }
            Element last = (Element)refList.get(refList.size() - 1);
            int minOccurs = 1;
            try {
                minOccurs = Integer.parseInt(last.getAttribute(MIN_OCCURS));
                last.setAttribute(MIN_OCCURS, Integer.toString(minOccurs += refList.size() - 1));
            }
            catch (NumberFormatException ne) {
                last.setAttribute(MIN_OCCURS, Integer.toString(minOccurs += refList.size() - 1));
                last.setAttribute(MAX_OCCURS, Integer.toString(minOccurs));
            }
            returnList.add(last);
        }
        return returnList;
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        Comment comment = this.doc.createComment(text.toString());
        this.stackElements.peek().appendChild(comment);
    }

    public void element(String name, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        Element element = this.doc.createElement(XSD_ELEMENT);
        element.setAttribute(ATTRIBUTE_REF, this.type + name);
        if (this.groupDepth > 0) {
            List<Object> listElement = null;
            if (this.listGroupElements.size() < this.groupDepth) {
                listElement = new ArrayList();
                this.listGroupElements.add(listElement);
            } else {
                listElement = this.listGroupElements.get(this.groupDepth - 1);
            }
            listElement.add(element);
        }
        this.stackElements.add(element);
        this.allElements.put(name, element);
    }

    public void elementDecl(String name, String contentModel, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void empty(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void endAttlist(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void endConditional(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void endContentModel(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        Element element = this.stackElements.pop();
        this.stackElements.peek().appendChild(element);
    }

    public void endDTD(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        if (log.isDebugEnabled()) {
            this.printDomNode(this.root);
        }
    }

    public void endExternalSubset(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void endGroup(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        --this.groupDepth;
        short type = this.listGroupTypes.remove(this.groupDepth);
        List<Element> listElement = this.listGroupElements.remove(this.groupDepth);
        this.stackElements.removeAll(listElement);
        if (listElement.size() == 1 && listElement.get(0).getTagName().equals(PCDATA)) {
            this.stackElements.peek().setAttribute(ATTRIBUTE_TYPE, XSD_STRING);
        } else {
            Element seq_cho = this.newSequenceOrChoice(type, listElement);
            if (this.groupDepth == 0) {
                Element complexType = this.doc.createElement(XSD_COMPLEX_TYPE);
                complexType.appendChild(seq_cho);
                this.stackElements.peek().appendChild(complexType);
            } else {
                this.listGroupElements.get(this.groupDepth - 1).add(seq_cho);
                this.stackElements.add(seq_cho);
            }
        }
        if (log.isDebugEnabled()) {
            this.printDomNode(this.stackElements.peek());
        }
    }

    public void endParameterEntity(String name, Augmentations augs) throws XNIException {
        this.hasParsed = this.parsedStack.pop();
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        throw new XNIException("domain=" + domain + ", key=" + key + ", exception=" + exception, (Exception)exception);
    }

    public void externalEntityDecl(String name, XMLResourceIdentifier identifier, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        throw new XNIException("domain=" + domain + ", key=" + key + ", exception=" + exception, (Exception)exception);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void ignoredCharacters(XMLString text, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    private Element newAttribute(String ename, String aname, String atype, String[] enums, String dtype, XMLString dvalue, XMLString nondvalue, Augmentations augs) {
        Element attr = this.doc.createElement(XSD_ATTRIBUTE);
        attr.setAttribute(NAME, aname);
        if (ENUMERATION_TYPE.equals(atype) || DTD_NOTATION.equals(atype)) {
            if (enums != null) {
                String typeName = ename + aname.substring(0, 1).toUpperCase() + aname.substring(1);
                attr.setAttribute(ATTRIBUTE_TYPE, this.type + typeName);
                Element simpleType = this.allElements.get(typeName);
                if (simpleType == null) {
                    simpleType = this.doc.createElement(XSD_SIMPLE_TYPE);
                    simpleType.setAttribute(NAME, typeName);
                    Element restriction = this.doc.createElement(XSD_RESTRICTION);
                    if (ENUMERATION_TYPE.equals(atype)) {
                        restriction.setAttribute(BASE, XSD_STRING);
                    } else {
                        restriction.setAttribute(BASE, XSD_NOTATION);
                    }
                    for (String value : enums) {
                        Element enumeration = this.doc.createElement(XSD_ENUMERATION);
                        enumeration.setAttribute(ATTRIBUTE_VALUE, value);
                        restriction.appendChild(enumeration);
                    }
                    simpleType.appendChild(restriction);
                    this.root.appendChild(simpleType);
                    this.allElements.put(typeName, simpleType);
                }
            }
        } else {
            String xsdType = null;
            for (TypePattern xsdPattern : this.listXsdTypePattern) {
                if (!xsdPattern.match(aname)) continue;
                xsdType = xsdPattern.getXsdType();
                break;
            }
            if (xsdType == null) {
                xsdType = this.dataTypeMap.get(atype);
            }
            if (xsdType != null) {
                attr.setAttribute(ATTRIBUTE_TYPE, xsdType);
            }
        }
        boolean fixed = false;
        if (REQUIRED_TYPE.equals(dtype)) {
            attr.setAttribute(USE, REQUIRED);
        } else if (FIXED_TYPE.equals(dtype)) {
            attr.setAttribute(ATTRIBUTE_FIXED, dvalue.toString());
            fixed = true;
        } else {
            attr.setAttribute(USE, OPTIONAL);
        }
        if (!fixed && dvalue != null) {
            attr.setAttribute(ATTRIBUTE_DEFAULT, dvalue.toString());
        }
        return attr;
    }

    private Element newSequenceOrChoice(short type, List<Element> listElement) {
        Element seq_cho = null;
        switch (type) {
            case 1: {
                seq_cho = this.doc.createElement(XSD_SEQUENCE);
                break;
            }
            case 0: {
                seq_cho = this.doc.createElement(XSD_CHOICE);
            }
        }
        List<Element> realListElement = listElement;
        if (type == 1) {
            realListElement = this.combineSequenceList(listElement);
        }
        for (Element child : realListElement) {
            seq_cho.appendChild(child);
        }
        return seq_cho;
    }

    public void notationDecl(String name, XMLResourceIdentifier identifier, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        Element notation = this.doc.createElement(XSD_NOTATION_LOWERCASE);
        notation.setAttribute(NAME, name);
        if (identifier != null && identifier.getLiteralSystemId() != null) {
            notation.setAttribute(ATTRIBUTE_PUBLIC, identifier.getLiteralSystemId());
        }
        this.stackElements.peek().appendChild(notation);
    }

    public void occurrence(short type, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        Element element = this.stackElements.peek();
        this.setOccursAttributes(element, type);
        if (log.isDebugEnabled()) {
            this.printDomNode(element);
        }
    }

    public void pcdata(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        Element pcdata = this.doc.createElement(PCDATA);
        if (this.groupDepth > 0) {
            List<Element> listElement = this.listGroupElements.get(this.groupDepth - 1);
            listElement.add(pcdata);
        }
        this.stackElements.add(pcdata);
    }

    private void printDomNode(Node node) {
        StringWriter out = new StringWriter();
        LSSerializer writer = this.domImpl.createLSSerializer();
        LSOutput output = this.domImpl.createLSOutput();
        output.setCharacterStream(out);
        output.setEncoding(UTF_8);
        writer.getDomConfig().setParameter(FORMAT_PRETTY_PRINT, Boolean.TRUE);
        writer.write(node, output);
        String str = output.getCharacterStream().toString();
        log.debug((Object)str);
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void separator(short type, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        if (this.listGroupTypes.get(this.groupDepth - 1) != type) {
            this.listGroupTypes.set(this.groupDepth - 1, type);
        }
    }

    private void setOccursAttributes(Element element, short type) {
        switch (type) {
            case 2: {
                element.setAttribute(MIN_OCCURS, "0");
                element.setAttribute(MAX_OCCURS, "1");
                break;
            }
            case 3: {
                element.setAttribute(MIN_OCCURS, "0");
                element.setAttribute(MAX_OCCURS, "unbounded");
                break;
            }
            case 4: {
                element.setAttribute(MIN_OCCURS, "1");
                element.setAttribute(MAX_OCCURS, "unbounded");
            }
        }
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void startAttlist(String name, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void startConditional(short type, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void startContentModel(String ename, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        Element element = this.doc.createElement(XSD_ELEMENT);
        element.setAttribute(NAME, ename);
        this.stackElements.add(element);
        this.allElements.put(ename, element);
    }

    public void startDTD(XMLLocator locator, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
            this.domImpl = (CoreDOMImplementationImpl)registry.getDOMImplementation("XML 3.0");
            this.doc = this.domImpl.createDocument(HTTP_WWW_W3_ORG_2001_XML_SCHEMA, XSD_SCHEMA, null);
            this.root = this.doc.getDocumentElement();
            if (this.targetNamespace != null) {
                this.root.setAttribute("targetNamespace", this.targetNamespace);
                this.root.setAttribute("xmlns:t", this.targetNamespace);
                this.type = "t:";
            } else {
                this.root.setAttribute("elementFormDefault", "qualified");
                this.root.setAttribute("attributeFormDefault", "unqualified");
                this.type = "";
            }
            this.stackElements.add(this.root);
        }
        catch (Exception e) {
            throw new XNIException(e);
        }
    }

    public void startExternalSubset(XMLResourceIdentifier identifier, Augmentations augs) throws XNIException {
    }

    public void startGroup(Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            return;
        }
        this.listGroupElements.add(new ArrayList());
        this.listGroupTypes.add(Short.valueOf("1"));
        ++this.groupDepth;
    }

    public void startParameterEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        if (this.setXmlResourceIdentifier.contains(name)) {
            this.parsedStack.add(this.hasParsed);
            this.hasParsed = true;
        } else {
            this.parsedStack.add(this.hasParsed);
            this.hasParsed = false;
            this.setXmlResourceIdentifier.add(name);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void unparsedEntityDecl(String name, XMLResourceIdentifier identifier, String notation, Augmentations augs) throws XNIException {
        if (this.hasParsed) {
            // empty if block
        }
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        log.warn((Object)("domain=" + domain + ", key=" + key + ", exception=" + exception), (Throwable)exception);
    }

    public void writeXsd(OutputStream out) {
        LSSerializer writer = this.domImpl.createLSSerializer();
        LSOutput output = this.domImpl.createLSOutput();
        output.setByteStream(out);
        output.setEncoding(UTF_8);
        writer.getDomConfig().setParameter(FORMAT_PRETTY_PRINT, Boolean.TRUE);
        writer.write(this.root, output);
    }

    public void writeXsd(Writer out) {
        LSSerializer writer = this.domImpl.createLSSerializer();
        LSOutput output = this.domImpl.createLSOutput();
        output.setCharacterStream(out);
        output.setEncoding(UTF_8);
        writer.getDomConfig().setParameter(FORMAT_PRETTY_PRINT, Boolean.TRUE);
        writer.write(this.root, output);
    }
}

