/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.tag;

import de.alpharogroup.lang.object.CloneObjectExtensions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimpleTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> attributes;
    private List<SimpleTag> children;
    private String content;
    private boolean endTag;
    private String name;

    public String addAttribute(String name, String value) {
        if (this.getAttributes() == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        return this.getAttributes().put(name, value);
    }

    public boolean addChild(SimpleTag child) {
        if (this.getChildren() == null) {
            this.children = new ArrayList<SimpleTag>();
        }
        return this.getChildren().add(child);
    }

    public Object clone() {
        return CloneObjectExtensions.cloneQuietly((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SimpleTag castedObj = (SimpleTag)o;
        return (this.attributes == null ? castedObj.attributes == null : this.attributes.equals(castedObj.attributes)) && (this.children == null ? castedObj.children == null : this.children.equals(castedObj.children)) && (this.content == null ? castedObj.content == null : this.content.equals(castedObj.content)) && this.endTag == castedObj.endTag && (this.name == null ? castedObj.name == null : this.name.equals(castedObj.name));
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<SimpleTag> getChildren() {
        return this.children;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + 1;
        hashCode = 31 * hashCode + (this.attributes == null ? 0 : this.attributes.hashCode());
        hashCode = 31 * hashCode + (this.children == null ? 0 : this.children.hashCode());
        hashCode = 31 * hashCode + (this.content == null ? 0 : this.content.hashCode());
        hashCode = 31 * hashCode + (this.endTag ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        return hashCode;
    }

    public boolean isEndTag() {
        return this.endTag;
    }

    public String removeAttribute(String name) {
        if (this.getAttributes() != null) {
            this.getAttributes().remove(name);
        }
        return null;
    }

    public boolean removeChild(SimpleTag child) {
        if (this.getChildren() != null) {
            return this.getChildren().remove(child);
        }
        return false;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setEndTag(boolean endTag) {
        this.endTag = endTag;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder buffer = this.toXmlString();
        return buffer.toString();
    }

    public StringBuilder toVelocityTemplate() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        buffer.append("${").append(this.getName()).append(".name}\n");
        if (this.getAttributes() != null && !this.getAttributes().isEmpty()) {
            buffer.append(" #foreach($attribute in $").append(this.getName()).append(".attributes.keySet())\n");
            buffer.append("$attribute=\"$").append(this.getName()).append(".getAttributes().get($attribute)\"\n");
            buffer.append(" #end\n");
        }
        buffer.append("#if(${").append(this.getName()).append(".endTag})>${").append(this.getName()).append(".content}\n");
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            buffer.append("#foreach($").append(this.getChildren().get(0).getName()).append(" in $").append(this.getName()).append(".children)\n");
            for (SimpleTag child : this.getChildren()) {
                buffer.append(child.toVelocityTemplate().toString());
            }
            buffer.append("#end\n");
        }
        buffer.append("</${").append(this.getName()).append(".name}>\n");
        buffer.append("#else />\n#end\n");
        return buffer;
    }

    public StringBuilder toXmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        buffer.append(this.getName());
        if (this.getAttributes() != null && !this.getAttributes().isEmpty()) {
            buffer.append(" ");
            for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
                buffer.append(entry.getKey());
                buffer.append("=");
                buffer.append("\"").append(entry.getValue()).append("\"");
                buffer.append(" ");
            }
        }
        if (this.isEndTag()) {
            buffer.append(">");
            buffer.append(this.getContent());
            if (this.getChildren() != null && !this.getChildren().isEmpty()) {
                for (SimpleTag child : this.getChildren()) {
                    buffer.append(child.toString());
                }
            }
            buffer.append("</");
            buffer.append(this.getName());
            buffer.append(">");
        } else {
            buffer.append("/>");
        }
        return buffer;
    }
}

