/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.tag;

import de.alpharogroup.lang.object.CloneObjectExtensions;
import de.alpharogroup.xml.tag.ChildTagPosition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Tag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> attributes;
    private List<ChildTagPosition> childTagPositions;
    private String content;
    private boolean endTag;
    private String name;

    public String addAttribute(String name, String value) {
        if (this.getAttributes() == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        return this.getAttributes().put(name, value);
    }

    public boolean addChild(Tag child, Integer position) {
        if (this.getChildren() == null) {
            this.childTagPositions = new ArrayList<ChildTagPosition>();
        }
        ChildTagPosition childTagPosition = new ChildTagPosition(child, position);
        return this.getChildren().add(childTagPosition);
    }

    public Object clone() {
        return CloneObjectExtensions.cloneQuietly((Object)this);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<ChildTagPosition> getChildren() {
        return this.childTagPositions;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEndTag() {
        return this.endTag;
    }

    public String removeAttribute(String name) {
        if (this.getAttributes() != null) {
            this.getAttributes().remove(name);
        }
        return null;
    }

    public boolean removeChild(Tag child) {
        if (this.getChildren() != null) {
            ChildTagPosition found = null;
            for (ChildTagPosition childTagPosition : this.getChildren()) {
                if (!childTagPosition.getChild().equals(child)) continue;
                found = childTagPosition;
            }
            if (found != null) {
                return this.getChildren().remove(found);
            }
        }
        return false;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setEndTag(boolean endTag) {
        this.endTag = endTag;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder buffer = this.toXmlString();
        return buffer.toString();
    }

    public StringBuilder toXmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        buffer.append(this.getName());
        if (this.getAttributes() != null && !this.getAttributes().isEmpty()) {
            buffer.append(" ");
            for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
                buffer.append(entry.getKey());
                buffer.append("=");
                buffer.append("\"").append(entry.getValue()).append("\"");
                buffer.append(" ");
            }
        }
        if (this.isEndTag()) {
            buffer.append(">");
            if (this.getChildren() != null && !this.getChildren().isEmpty()) {
                String processingContent = this.getContent();
                Integer lastPosition = 0;
                for (ChildTagPosition child : this.getChildren()) {
                    String subContent = this.getContent().substring(lastPosition, child.getPosition());
                    lastPosition = child.getPosition();
                    processingContent = processingContent.substring(lastPosition, processingContent.length());
                    buffer.append(subContent);
                    buffer.append(child.getChild().toString());
                }
                buffer.append(processingContent);
            } else {
                buffer.append(this.getContent());
            }
            buffer.append("</");
            buffer.append(this.getName());
            buffer.append(">");
        } else {
            buffer.append("/>");
        }
        return buffer;
    }
}

