/*
 * Decompiled with CFR 0.152.
 */
package de.andrena.tools.macker.plugin;

import de.andrena.tools.macker.plugin.CommandLineBuilder;
import de.andrena.tools.macker.plugin.CommandLineFile;
import de.andrena.tools.macker.plugin.JavaShell;
import de.andrena.tools.macker.plugin.Macker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkedMacker
implements Macker {
    private static final String COMMAND_CLASS = CommandLineFile.class.getName();
    private static final String TASK_CLASS = "de.andrena.tools.macker.Macker";
    private List<String> options = new ArrayList<String>();
    private List<String> rules = new ArrayList<String>();
    private List<String> classes = new ArrayList<String>();
    private Log log = new SystemStreamLog();
    private String maxmem;
    private List<Artifact> pluginClasspathList = Collections.emptyList();
    private boolean quiet;

    private String createClasspath() throws MojoExecutionException {
        StringBuffer cpBuffer = new StringBuffer();
        Iterator<Artifact> it = this.pluginClasspathList.iterator();
        while (it.hasNext()) {
            Artifact artifact = it.next();
            try {
                cpBuffer.append(artifact.getFile().getCanonicalPath());
                if (!it.hasNext()) continue;
                cpBuffer.append(File.pathSeparator);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        return cpBuffer.toString();
    }

    private Commandline createCommandLine() throws MojoExecutionException {
        ArrayList<String> jvmArguments = new ArrayList<String>();
        jvmArguments.add("-cp");
        jvmArguments.add(this.createClasspath());
        if (this.maxmem != null) {
            jvmArguments.add("-Xmx" + this.maxmem);
        }
        Commandline cl = new Commandline((Shell)new JavaShell(jvmArguments));
        cl.setExecutable(COMMAND_CLASS);
        cl.createArg().setValue(TASK_CLASS);
        try {
            CommandLineBuilder builder = new CommandLineBuilder("macker");
            Iterator<String> it = this.options.iterator();
            while (it.hasNext()) {
                builder.addArg(it.next());
            }
            it = this.rules.iterator();
            while (it.hasNext()) {
                builder.addArg(it.next());
            }
            it = this.classes.iterator();
            while (it.hasNext()) {
                builder.addArg(it.next());
            }
            builder.saveArgs();
            String commandsFile = builder.getCommandLineFile();
            cl.createArg().setValue(commandsFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create CommandsFile.", (Exception)e);
        }
        return cl;
    }

    private int executeJava() throws MojoExecutionException {
        String stream;
        int exitCode;
        Commandline cl = this.createCommandLine();
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.quiet) {
            CommandLineUtils.StringStreamConsumer nullConsumer;
            stdout = nullConsumer = new CommandLineUtils.StringStreamConsumer(){

                public void consumeLine(String s) {
                }
            };
            stderr = nullConsumer;
        }
        this.log.debug((CharSequence)("Working Directory: " + cl.getWorkingDirectory()));
        this.log.debug((CharSequence)"Executing command line:");
        this.log.debug((CharSequence)cl.toString());
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute Macker.", (Exception)((Object)e));
        }
        this.log.debug((CharSequence)("exit code: " + exitCode));
        String output = stdout.getOutput();
        if (output.trim().length() > 0) {
            this.log.debug((CharSequence)"--------------------");
            this.log.debug((CharSequence)" Standard output from the Macker task:");
            this.log.debug((CharSequence)"--------------------");
            this.log.info((CharSequence)output);
            this.log.debug((CharSequence)"--------------------");
        }
        if ((stream = stderr.getOutput()).trim().length() > 0) {
            this.log.debug((CharSequence)"--------------------");
            this.log.debug((CharSequence)" Standard error from the Macker task:");
            this.log.debug((CharSequence)"--------------------");
            this.log.error((CharSequence)stderr.getOutput());
            this.log.debug((CharSequence)"--------------------");
        }
        return exitCode;
    }

    @Override
    public void check() throws MojoExecutionException, MojoFailureException {
        int returnCode = this.executeJava();
        switch (returnCode) {
            case 0: {
                this.log.debug((CharSequence)"All checks passed.");
                break;
            }
            case 2: {
                this.log.debug((CharSequence)"Macker check failed.");
                throw new MojoFailureException("MackerIsMadException during Macker execution");
            }
            default: {
                this.log.error((CharSequence)"Macker check had errors. See messages above.");
                throw new MojoExecutionException("Error during Macker execution");
            }
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setMaxmem(String maxmem) {
        this.maxmem = maxmem;
    }

    public void setPluginClasspathList(List<Artifact> pluginClasspathList) {
        this.pluginClasspathList = Collections.unmodifiableList(pluginClasspathList);
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void addClass(File clazz) throws IOException {
        this.classes.add(clazz.getCanonicalPath());
    }

    @Override
    public void addRulesFile(File rule) throws IOException {
        this.rules.add("-r");
        this.rules.add(rule.getCanonicalPath());
    }

    @Override
    public void setAngerThreshold(String anger) {
        this.options.add("--anger");
        this.options.add(anger);
    }

    @Override
    public void setPrintMaxMessages(int maxMsg) {
        this.options.add("--print-max");
        this.options.add("" + maxMsg);
    }

    @Override
    public void setPrintThreshold(String print) {
        this.options.add("--print");
        this.options.add(print);
    }

    @Override
    public void setVariable(String name, String value) {
        this.options.add("-D");
        this.options.add(name + "=" + value);
    }

    @Override
    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.options.add("-v");
        }
    }

    @Override
    public void setXmlReportFile(File report) throws IOException {
        this.options.add("-o");
        this.options.add(report.getCanonicalPath());
    }
}

