/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor;

import clazzfish.monitor.util.ReflectionHelper;
import java.net.URLClassLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ClassloaderType {
    UNKNOWN("unknown"),
    SUN("sun.misc.Launcher$AppClassLoader"),
    JDK("jdk.internal.loader.ClassLoaders$AppClassLoader"),
    NET(URLClassLoader.class),
    TOMCAT("org.apache.catalina.loader.WebappClassLoader", true, "repositoryURLs"),
    TOMCAT8("org.apache.catalina.loader.WebappClassLoaderBase", true, "localRepositories"),
    WEBLOGIC("weblogic.utils.classloaders.ChangeAwareClassLoader", true),
    WEBSPHERE("com.ibm.ws.classloader.CompoundClassLoader", true, "localClassPath"),
    SUREFIRE("org.apache.maven.surefire.booter.IsolatedClassLoader");

    private static final Logger LOG;
    private Class<? extends ClassLoader> classLoader = null;
    private final String classname;
    private final String fieldname;
    private final boolean web;

    private ClassloaderType(Class<? extends ClassLoader> classLoader) {
        this(classLoader.getName(), false);
        this.classLoader = classLoader;
    }

    private ClassloaderType(String classname) {
        this(classname, false);
    }

    private ClassloaderType(String classname, boolean web) {
        this(classname, web, "");
    }

    private ClassloaderType(String classname, boolean web, String fieldname) {
        this.classname = classname;
        this.fieldname = fieldname;
        this.web = web;
    }

    public boolean isWeb() {
        return this.web;
    }

    public static ClassloaderType toClassloaderType(ClassLoader cloader) {
        ClassloaderType[] clTypes;
        for (ClassloaderType type : clTypes = ClassloaderType.values()) {
            if (!ClassloaderType.isAssignableClassloader(cloader.getClass(), type) || !StringUtils.isEmpty((CharSequence)type.fieldname) && !ReflectionHelper.hasField(cloader, type.fieldname)) continue;
            return type;
        }
        for (ClassloaderType type : clTypes) {
            if (ReflectionHelper.hasField(cloader, type.fieldname)) {
                return type;
            }
            if (type.classLoader == null || !type.classLoader.isAssignableFrom(cloader.getClass())) continue;
            return type;
        }
        LOG.debug("{} is considered to be a default classloader (SUN).", (Object)cloader);
        return SUN;
    }

    private static boolean isAssignableClassloader(Class<? extends ClassLoader> cloaderClass, ClassloaderType type) {
        if (cloaderClass.getName().equals(type.classname)) {
            return true;
        }
        Class<? extends ClassLoader> superclass = cloaderClass.getSuperclass();
        if (superclass == null || superclass.equals(URLClassLoader.class)) {
            return false;
        }
        return ClassloaderType.isAssignableClassloader(superclass, type);
    }

    public static ClassloaderType getCurrentClassloaderType() {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        return ClassloaderType.toClassloaderType(cloader);
    }

    public static boolean isSupported(String classloaderName) {
        ClassloaderType[] types;
        for (ClassloaderType type : types = ClassloaderType.values()) {
            if (!classloaderName.equals(type.classname)) continue;
            return true;
        }
        return false;
    }

    public Object getClasspathFrom(ClassLoader cloader) {
        try {
            return ReflectionHelper.getFieldValue(cloader, this.fieldname);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException(cloader + ": cannot access field '" + this.fieldname + "'", ex);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ClassloaderType.class);
    }
}

