/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor;

import clazzfish.monitor.AbstractMonitor;
import clazzfish.monitor.ClasspathMonitorMBean;
import clazzfish.monitor.ResourcepathMonitor;
import clazzfish.monitor.internal.ClasspathDigger;
import clazzfish.monitor.internal.DoubletDigger;
import clazzfish.monitor.jmx.MBeanHelper;
import clazzfish.monitor.util.ArchivEntry;
import clazzfish.monitor.util.ClasspathHelper;
import clazzfish.monitor.util.Converter;
import clazzfish.monitor.util.ObjectComparator;
import clazzfish.monitor.util.ReflectionHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathMonitor
extends AbstractMonitor
implements ClasspathMonitorMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathMonitor.class);
    private static final Executor EXECUTOR = Executors.newCachedThreadPool();
    private static final ClasspathMonitor INSTANCE;
    private static final String[] DUMP_GETTERS;
    private static final URI NULL_URI;
    private final ClasspathDigger classpathDigger;
    private final DoubletDigger doubletDigger;
    private final ClassLoader cloader;
    private final String[] classpath;
    private String[] loadedClasses = new String[0];
    private final FutureTask<String[]> allClasspathClasses;
    private final FutureTask<Set<String>> unusedClasses;
    private final Map<Class<?>, URI> usedClassCache = new ConcurrentHashMap();
    private final Map<Class<?>, URI> usedClasspathCache = new ConcurrentHashMap();
    private final List<Class<?>> incompatibleClassList = new ArrayList();

    protected ClasspathMonitor() {
        this.classpathDigger = new ClasspathDigger();
        this.cloader = this.classpathDigger.getClassLoader();
        this.classpath = this.classpathDigger.getClasspath();
        this.allClasspathClasses = this.getFutureCasspathClasses();
        this.unusedClasses = this.getFutureUnusedClasses();
        this.doubletDigger = new DoubletDigger(this.classpathDigger);
    }

    private FutureTask<String[]> getFutureCasspathClasses() {
        FutureTask<String[]> classes = new FutureTask<String[]>(this::getClasspathClassArray);
        EXECUTOR.execute(classes);
        return classes;
    }

    private FutureTask<Set<String>> getFutureUnusedClasses() {
        FutureTask<Set<String>> classes = new FutureTask<Set<String>>(this::getClasspathClassSet);
        EXECUTOR.execute(classes);
        return classes;
    }

    public static ClasspathMonitor getInstance() {
        return INSTANCE;
    }

    public static void registerAsMBean() {
        ClasspathMonitor.getInstance().registerMeAsMBean();
    }

    public static void registerAsMBean(String name) {
        ClasspathMonitor.registerAsMBean(MBeanHelper.getAsObjectName(name));
    }

    public static synchronized void registerAsMBean(ObjectName name) {
        if (ClasspathMonitor.isRegisteredAsMBean()) {
            LOG.debug("MBean already registered - registerAsMBean(\"{}\") ignored.", (Object)name);
        } else {
            ClasspathMonitor.getInstance().registerMeAsMBean(name);
        }
    }

    public static void unregisterAsMBean() {
        ClasspathMonitor.getInstance().unregisterMeAsMBean();
    }

    public static boolean isRegisteredAsMBean() {
        return ClasspathMonitor.getInstance().isMBean();
    }

    @Override
    public URI whichClass(String name) {
        String resource = Converter.classToResource(name);
        return this.classpathDigger.whichResource(resource);
    }

    public URI whichClass(Class<?> clazz) {
        LOG.trace("Searching {} in classpath.", clazz);
        URI uri = this.usedClassCache.get(clazz);
        if (uri == null) {
            uri = this.whichClass(clazz.getName());
            if (uri == null) {
                LOG.trace("{} was not found in classpath.", clazz);
            } else {
                this.usedClassCache.put(clazz, uri);
            }
        }
        LOG.trace("Searching {} in classpath finished, {} found.", clazz, (Object)uri);
        return uri;
    }

    public URI whichClassPath(String classname) {
        String resource = Converter.classToResource(classname);
        return this.whichResourcePath(resource);
    }

    public URI whichClassPath(Class<?> clazz) {
        return this.whichClassPath(clazz.getName());
    }

    public URI whichClassPath(Package p) {
        String resource = Converter.toResource(p);
        return this.whichResourcePath(resource);
    }

    public URI whichResourcePath(String resource) {
        URI uri = this.classpathDigger.whichResource(resource);
        return ClasspathHelper.getParent(uri, resource);
    }

    public JarFile whichClassJar(Class<?> clazz) {
        return this.whichClassJar(clazz.getName());
    }

    public JarFile whichClassJar(String classname) {
        String resource = Converter.classToResource(classname);
        return this.whichResourceJar(resource);
    }

    public Path whichPath(Class<?> clazz) {
        return this.whichPath(Converter.classToResource(clazz.getName()));
    }

    public Path whichPath(String resource) {
        URI uri = this.whichResourcePath(resource);
        if ("jrt".equals(uri.getScheme())) {
            FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            return fs.getPath("modules", uri.getPath(), resource);
        }
        try {
            uri = this.classpathDigger.whichResource(resource);
            return Paths.get(uri.toURL().getPath(), new String[0]);
        }
        catch (MalformedURLException ex) {
            LOG.warn("Cannot convert {} to URL:", (Object)uri, (Object)ex);
            return Paths.get(uri);
        }
    }

    public JarFile whichResourceJar(String resource) {
        return ClasspathMonitor.whichResourceJar(this.whichResourcePath(resource));
    }

    public static JarFile whichResourceJar(URI resource) {
        if (resource == null) {
            return null;
        }
        File file = Converter.toFile(resource);
        try {
            return new JarFile(file);
        }
        catch (IOException ioe) {
            LOG.debug("Cannot read " + file + ":", (Throwable)ioe);
            return null;
        }
    }

    public Enumeration<URL> getResources(String name) {
        return this.classpathDigger.getResources(name);
    }

    public static URL getResource(String name) {
        return ClasspathMonitor.class.getResource(name);
    }

    public int getNoClasses(Class<?> cl) {
        return this.getNoClasses(cl.getName());
    }

    @Override
    public int getNoClasses(String classname) {
        return ResourcepathMonitor.getInstance().getNoResources(Converter.classToResource(classname));
    }

    @Override
    public boolean isDoublet(Class<?> clazz) {
        return this.doubletDigger.isDoublet(clazz);
    }

    @Override
    public URI getFirstDoublet(Class<?> clazz) {
        return this.getDoublet(clazz, 1);
    }

    @Override
    public URI getDoublet(Class<?> clazz, int nr) {
        return this.doubletDigger.getDoublet(clazz, nr);
    }

    public synchronized List<Class<?>> getDoubletList() {
        return this.doubletDigger.getDoubletClassList();
    }

    @Override
    public String[] getDoublets() {
        return this.doubletDigger.getDoubletClasses();
    }

    @Override
    public String[] getDoubletClasspath() {
        URI[] classpathURIs = this.getDoubletClasspathURIs();
        return ClasspathMonitor.toStringArray(classpathURIs);
    }

    public URI[] getDoubletClasspathURIs() {
        LOG.trace("Calculating doublet-classpath.");
        SortedSet<URI> classpathSet = this.getClasspathSet(this.getDoubletList());
        return classpathSet.toArray(new URI[classpathSet.size()]);
    }

    private SortedSet<URI> getClasspathSet(List<Class<?>> classes) {
        ArrayList<String> classResources = new ArrayList<String>();
        for (Class<?> cl : classes) {
            classResources.add(Converter.toResource(cl));
        }
        return this.classpathDigger.getResourcepathSet(classResources);
    }

    public String getClassLoaderDetails() {
        StringBuilder sbuf = new StringBuilder("dump of " + this.cloader + ":\n");
        for (Class<?> cl = this.cloader.getClass(); cl != null; cl = cl.getSuperclass()) {
            sbuf.append('\t');
            ClasspathMonitor.dumpFields(sbuf, cl, this.cloader);
        }
        return sbuf.toString().trim();
    }

    private static void dumpFields(StringBuilder sbuf, Class<?> cl, Object obj) {
        AccessibleObject[] fields = cl.getDeclaredFields();
        try {
            AccessibleObject.setAccessible(fields, true);
        }
        catch (InaccessibleObjectException ex) {
            LOG.info("Start JVM with '--add-opens java.base/jdk.internal.loader=ALL-UNNAMED' to dump fields of {}.", cl);
            LOG.debug("Details:", (Throwable)ex);
        }
        for (int i = 0; i < fields.length; ++i) {
            sbuf.append(fields[i]);
            sbuf.append(" = ");
            try {
                sbuf.append(((Field)fields[i]).get(obj));
            }
            catch (IllegalAccessException ex) {
                LOG.info("Cannot access field {} {}.", (Object)i, (Object)fields[i]);
                LOG.debug("Details:", (Throwable)ex);
                sbuf.append("???");
            }
            sbuf.append('\n');
        }
    }

    @Override
    public boolean isClassloaderSupported() {
        return this.classpathDigger.isClassloaderSupported();
    }

    @Override
    public String getClassloaderInfo() {
        String info = this.isClassloaderSupported() ? "supported" : "unsupported";
        return this.cloader.getClass().getName() + " (" + info + ")";
    }

    @Override
    public String[] getLoadedPackages() {
        Package[] packages = this.classpathDigger.getLoadedPackageArray();
        Object[] strings = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            strings[i] = packages[i].toString();
        }
        Arrays.sort(strings);
        return strings;
    }

    public Package[] getLoadedPackageArray() {
        return this.classpathDigger.getLoadedPackageArray();
    }

    public String getLoadedPackagesAsString() {
        String[] packages = this.getLoadedPackages();
        StringBuilder sbuf = new StringBuilder();
        for (String pkg : packages) {
            sbuf.append(pkg);
            sbuf.append('\n');
        }
        return sbuf.toString().trim();
    }

    public synchronized List<Class<?>> getLoadedClassList() {
        return this.classpathDigger.getLoadedClasses();
    }

    @Override
    public synchronized String[] getLoadedClasses() {
        List<Class<?>> classes = this.getLoadedClassList();
        if (classes.size() != this.loadedClasses.length) {
            this.loadedClasses = new String[classes.size()];
            for (int i = 0; i < this.loadedClasses.length; ++i) {
                this.loadedClasses[i] = classes.get(i).toString();
            }
            Arrays.sort(this.loadedClasses);
        }
        return (String[])this.loadedClasses.clone();
    }

    public String getLoadedClassesAsString() {
        List<Class<?>> classes = this.getLoadedClassList();
        Collections.sort(classes, new ObjectComparator());
        StringBuilder sbuf = new StringBuilder();
        Iterator<Class<?>> i = classes.iterator();
        while (i.hasNext()) {
            sbuf.append(i.next().toString().trim());
            sbuf.append('\n');
        }
        return sbuf.toString().trim();
    }

    @Override
    public boolean isLoaded(String classname) {
        return this.classpathDigger.isLoaded(classname);
    }

    @Override
    public String[] getUnusedClasses() {
        List<Class<?>> classes = this.getLoadedClassList();
        ArrayList<String> used = new ArrayList<String>();
        Set<String> unusedSet = this.getUnusedClassSet();
        for (Class<?> cl : classes) {
            String classname = cl.getName();
            if (!unusedSet.contains(classname)) continue;
            used.add(classname);
        }
        unusedSet.removeAll(used);
        String[] unused = new String[unusedSet.size()];
        unusedSet.toArray(unused);
        return unused;
    }

    private Set<String> getUnusedClassSet() {
        try {
            return this.unusedClasses.get();
        }
        catch (InterruptedException e) {
            LOG.warn("Was interrupted before got result from {}:", this.unusedClasses, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.warn("Cannot execute get of {}:", this.unusedClasses, (Object)e);
        }
        return this.getClasspathClassSet();
    }

    @Override
    public String[] getClasspathClasses() {
        try {
            return this.allClasspathClasses.get();
        }
        catch (InterruptedException e) {
            LOG.warn("Was interrupted before got result from {}:", this.allClasspathClasses, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.warn("Cannot execute get of {}:", this.allClasspathClasses, (Object)e);
        }
        return this.getClasspathClassArray();
    }

    private Set<String> getClasspathClassSet() {
        String[] classes = this.getClasspathClasses();
        return new TreeSet<String>(Arrays.asList(classes));
    }

    public Collection<String> getClasspathClassList(String packageName) {
        ArrayList<String> classlist = new ArrayList<String>();
        String[] classes = this.getClasspathClasses();
        Object prefix = packageName.endsWith(".") ? packageName : packageName + ".";
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].startsWith((String)prefix)) continue;
            classlist.add(classes[i]);
        }
        return classlist;
    }

    public <T> Collection<Class<? extends T>> getClassList(String packageName, Class<T> type) {
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        Collection<Class<? extends Object>> concreteClasses = this.getConcreteClassList(packageName);
        for (Class<? extends Object> clazz : concreteClasses) {
            if (!type.isAssignableFrom(clazz)) continue;
            classes.add(clazz);
            LOG.trace("subclass of {} found: {}", type, clazz);
        }
        return classes;
    }

    public Collection<Class<? extends Object>> getConcreteClassList(String packageName) {
        assert (packageName != null);
        Collection<String> classList = this.getClasspathClassList(packageName);
        ArrayList<Class<? extends Object>> classes = new ArrayList<Class<? extends Object>>(classList.size());
        for (String classname : classList) {
            try {
                Class<?> clazz = Class.forName(classname);
                if (!ClasspathMonitor.canBeInstantiated(clazz)) {
                    LOG.trace("{} will be ignored (can't be instantiated).", clazz);
                    continue;
                }
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Class '{}' is ignored because it was not found:", (Object)classname, (Object)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.debug("Class '{}' is ignored because definition was not found:", (Object)classname, (Object)e);
            }
            catch (ExceptionInInitializerError ex) {
                LOG.debug("Class '{}' is ignored because it cannot be initialized:", (Object)classname, (Object)ex);
            }
        }
        return classes;
    }

    private static boolean canBeInstantiated(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        int mod = clazz.getModifiers();
        if (Modifier.isAbstract(mod)) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
            return true;
        }
        catch (SecurityException ex) {
            LOG.info("Cannot access default ctor {}:", clazz, (Object)ex);
            return false;
        }
        catch (NoSuchMethodException ex) {
            LOG.trace("Cannot get default ctor of {}:", clazz, (Object)ex);
            LOG.debug("{} has no default constructor.", clazz);
            return false;
        }
    }

    private String[] getClasspathClassArray() {
        Set<String> classSet = this.classpathDigger.getClasses();
        return classSet.toArray(new String[classSet.size()]);
    }

    public SortedSet<URI> getUsedClasspathSet() {
        List<Class<?>> loadedClassList = this.getLoadedClassList();
        TreeSet<URI> usedClasspathSet = new TreeSet<URI>();
        for (Class<?> clazz : loadedClassList) {
            URI classpathUri = this.getClasspathOf(clazz);
            if (NULL_URI.equals(classpathUri)) continue;
            usedClasspathSet.add(classpathUri);
        }
        return usedClasspathSet;
    }

    private URI getClasspathOf(Class<?> clazz) {
        URI classpathUri = this.usedClasspathCache.get(clazz);
        if (classpathUri == null) {
            URI classUri = this.whichClass(clazz);
            if (classUri == null) {
                LOG.trace("URI for {} was not found (probably a proxy class).", clazz);
                classpathUri = NULL_URI;
            } else {
                classpathUri = ClasspathHelper.getParent(classUri, clazz);
            }
            this.usedClasspathCache.put(clazz, classpathUri);
        }
        return classpathUri;
    }

    @Override
    public String[] getUsedClasspath() {
        URI[] uris = this.getUsedClasspathURIs();
        return ClasspathMonitor.toStringArray(uris);
    }

    public URI[] getUsedClasspathURIs() {
        LOG.debug("calculating used classpath...");
        SortedSet<URI> classpathSet = this.getUsedClasspathSet();
        return classpathSet.toArray(new URI[classpathSet.size()]);
    }

    @Override
    public String[] getUnusedClasspath() {
        LOG.debug("calculating unused classpath...");
        TreeSet<String> unused = new TreeSet<String>();
        LOG.trace(Arrays.class + " loaded (to get corrected used classpath");
        Object[] used = this.getUsedClasspath();
        for (String s : this.classpath) {
            String path = new File(s).getAbsolutePath();
            if (Arrays.binarySearch(used, path) >= 0) continue;
            unused.add(path);
        }
        String[] a = new String[unused.size()];
        return unused.toArray(a);
    }

    public SortedSet<URI> getUnusedClasspathSet() {
        return ClasspathMonitor.toUriSet(this.getUnusedClasspath());
    }

    @Override
    public String[] getBootClasspath() {
        return this.classpathDigger.getBootClasspath();
    }

    @Override
    public String[] getClasspath() {
        return (String[])this.classpath.clone();
    }

    public SortedSet<URI> getClasspathSet() {
        return ClasspathMonitor.toUriSet(this.classpath);
    }

    private static SortedSet<URI> toUriSet(String[] array) {
        TreeSet<URI> set = new TreeSet<URI>();
        for (String s : array) {
            File f = new File(s);
            if (f.isDirectory()) {
                set.add(f.toURI());
                continue;
            }
            set.add(URI.create("jar:" + f.toURI()));
        }
        return set;
    }

    @Override
    public Long getSerialVersionUID(String classname) throws IllegalAccessException {
        try {
            Class<?> clazz = Class.forName(classname);
            return this.getSerialVersionUID(clazz);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Class '" + classname + "' not found:", (Throwable)e);
            return null;
        }
    }

    public Long getSerialVersionUID(Class<?> clazz) throws IllegalAccessException {
        try {
            Field field = ReflectionHelper.getField(clazz, "serialVersionUID");
            return (Long)field.get(null);
        }
        catch (NoSuchFieldException ex) {
            LOG.debug(clazz + " has no serialVersionUID:", (Throwable)ex);
            return null;
        }
    }

    public String[] getManifestEntries(Class<?> clazz) {
        return this.getManifestEntries(clazz.getName());
    }

    @Override
    public String[] getManifestEntries(String classname) {
        URI classpathURI = this.whichClassPath(classname);
        if (classpathURI == null) {
            throw new IllegalArgumentException(classname + " not found in classpath");
        }
        File path = Converter.toFile(classpathURI);
        return this.getManifestEntries(path);
    }

    private String[] getManifestEntries(File path) {
        String[] stringArray;
        if (path.isFile()) {
            try {
                return this.getManifestEntries(new JarFile(path));
            }
            catch (IOException ioe) {
                LOG.info("No manifest found in " + path + ":", (Throwable)ioe);
                return new String[0];
            }
        }
        File manifestFile = new File(path, "META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            LOG.debug("File '{}' does not exist.", (Object)manifestFile);
            return new String[0];
        }
        FileInputStream istream = new FileInputStream(manifestFile);
        try {
            Manifest manifest = new Manifest(istream);
            stringArray = this.getManifestEntries(manifest);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)istream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                LOG.info("Cannot read '" + manifestFile + "':", (Throwable)ioe);
                return new String[0];
            }
        }
        ((InputStream)istream).close();
        return stringArray;
    }

    private String[] getManifestEntries(JarFile jarfile) {
        Manifest manifest;
        try {
            manifest = jarfile.getManifest();
        }
        catch (IOException ioe) {
            LOG.info("No manifest found in '" + jarfile + "':", (Throwable)ioe);
            return new String[0];
        }
        if (manifest == null) {
            LOG.debug("No manifest found in '{}'.", (Object)jarfile);
            return new String[0];
        }
        return this.getManifestEntries(manifest);
    }

    private String[] getManifestEntries(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String[] manifestEntries = new String[attributes.size()];
        Set<Map.Entry<Object, Object>> entries = attributes.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = entries.iterator();
        for (int i = 0; i < manifestEntries.length; ++i) {
            Map.Entry<Object, Object> entry = iterator.next();
            manifestEntries[i] = entry.getKey() + ": " + entry.getValue();
        }
        return manifestEntries;
    }

    public synchronized List<Class<?>> getIncompatibleClassList() {
        List<Class<?>> doublets = this.getDoubletList();
        for (Class<?> clazz : doublets) {
            if (this.incompatibleClassList.contains(clazz)) continue;
            String resource = Converter.classToResource(clazz.getName());
            Enumeration<URL> resources = this.getResources(resource);
            try {
                URL url = resources.nextElement();
                ArchivEntry archivEntry = new ArchivEntry(url);
                while (resources.hasMoreElements()) {
                    url = resources.nextElement();
                    ArchivEntry doubletEntry = new ArchivEntry(url);
                    if (archivEntry.equals(doubletEntry)) continue;
                    this.incompatibleClassList.add(clazz);
                }
            }
            catch (NoSuchElementException nse) {
                LOG.warn("{} is not added to incompatible class list:", clazz, (Object)nse);
            }
        }
        return Collections.unmodifiableList(this.incompatibleClassList);
    }

    @Override
    public String[] getIncompatibleClasses() {
        LOG.debug("Calculating incompatible classes...");
        List<Class<?>> classList = this.getIncompatibleClassList();
        String[] classes = new String[classList.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = classList.get(i).toString();
        }
        return classes;
    }

    @Override
    public String[] getIncompatibleClasspath() {
        URI[] classpathURIs = this.getIncompatibleClasspathURIs();
        return ClasspathMonitor.toStringArray(classpathURIs);
    }

    public URI[] getIncompatibleClasspathURIs() {
        LOG.debug("calculating incompatible-classpath...");
        SortedSet<URI> classpathSet = this.getClasspathSet(this.getIncompatibleClassList());
        return classpathSet.toArray(new URI[0]);
    }

    public static synchronized void addAsShutdownHook() {
        INSTANCE.addMeAsShutdownHook();
    }

    public static synchronized void removeAsShutdownHook() {
        INSTANCE.removeMeAsShutdownHook();
    }

    @Override
    public void logMe() {
        try {
            StringWriter writer = new StringWriter();
            this.dumpMe(writer);
            LOG.info(writer.toString());
        }
        catch (IOException cannothappen) {
            LOG.warn("Will only dump classloader info:", (Throwable)cannothappen);
            LOG.info(this.getClassloaderInfo());
        }
    }

    @Override
    public void dumpMe(File dumpDir) throws IOException {
        this.dump(dumpDir, DUMP_GETTERS);
        this.dumpClassloaderInfo(dumpDir);
        this.copyResource("CpMonREADME.txt", new File(dumpDir, "README.txt"));
    }

    private void dumpMe(Writer unbuffered) throws IOException {
        BufferedWriter writer = new BufferedWriter(unbuffered);
        this.dump(writer, DUMP_GETTERS);
        this.dumpClassloaderInfo(writer);
        writer.flush();
    }

    private void dumpClassloaderInfo(File dir) throws IOException {
        File dumpFile = new File(dir, "ClassloaderInfo.txt");
        LOG.debug("Dumping classloader info to {}...", (Object)dumpFile);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), StandardCharsets.UTF_8);){
            this.dumpClassloaderInfo(new BufferedWriter(writer));
            writer.flush();
        }
    }

    private void dumpClassloaderInfo(BufferedWriter writer) throws IOException {
        ClasspathMonitor.dumpHeadline(writer, "ClassloaderInfo");
        writer.write(this.getClassloaderInfo());
        writer.newLine();
        writer.newLine();
        ClasspathMonitor.dumpHeadline(writer, "=== ClassLoaderDetails ===");
        writer.write(this.getClassLoaderDetails());
        writer.newLine();
        ClasspathMonitor.dumpHeadline(writer, "ClassloaderInfo (end)");
        writer.flush();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.cloader;
    }

    @Override
    public boolean isMultiThreadingEnabled() {
        return this.doubletDigger.isMultiThreadingEnabled();
    }

    @Override
    public void setMultiThreadingEnabled(boolean enabled) {
        this.doubletDigger.setMultiThreadingEnabled(enabled);
    }

    static {
        DUMP_GETTERS = new String[]{"BootClasspath", "Classpath", "ClasspathClasses", "DoubletClasspath", "DoubletClasspathURIs", "Doublets", "LoadedClasses", "LoadedPackages", "IncompatibleClasses", "IncompatibleClasspath", "IncompatibleClasspathURIs", "UnusedClasses", "UnusedClasspath", "UsedClasspath", "UsedClasspathURIs"};
        NULL_URI = URI.create("http://null");
        INSTANCE = new ClasspathMonitor();
    }
}

