/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.internal;

import clazzfish.monitor.util.NestedZipFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDigger {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDigger.class);

    public abstract Enumeration<URL> getResources(String var1);

    protected static Collection<String> readElementsFromNestedArchive(File archive) throws IOException {
        String path = StringUtils.removeEnd((String)archive.getPath(), (String)"!");
        String archiveDir = "";
        if (!path.toLowerCase().matches(".*\\.[jwe]ar")) {
            archiveDir = StringUtils.substringAfterLast((String)path, (String)"!");
            archiveDir = FilenameUtils.separatorsToUnix((String)archiveDir);
            path = StringUtils.substringBeforeLast((String)path, (String)"!");
        }
        return AbstractDigger.readElementsFromArchive(new File(path), archiveDir);
    }

    private static Collection<String> readElementsFromArchive(File archive, String archiveDir) throws IOException {
        ArrayList<String> elements = new ArrayList<String>();
        try (NestedZipFile zipFile = new NestedZipFile(archive);){
            String relPath = archiveDir.startsWith("/") ? archiveDir.substring(1) : archiveDir;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(relPath)) continue;
                elements.add(name.substring(relPath.length()));
            }
            LOG.trace("{} element(s) read from {}.", (Object)elements.size(), (Object)archive);
            ArrayList<String> arrayList = elements;
            return arrayList;
        }
    }
}

