/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.internal;

import clazzfish.monitor.internal.ClasspathDigger;
import clazzfish.monitor.util.Converter;
import clazzfish.monitor.util.ObjectComparator;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DoubletDigger {
    private static final Logger LOG = LoggerFactory.getLogger(DoubletDigger.class);
    private final Map<Class<?>, Boolean> doubletClasses = new ConcurrentHashMap();
    private final ClassLoader cloader;
    private final ClasspathDigger classpathDigger;
    private final List<Class<?>> doubletList = new CopyOnWriteArrayList();
    private boolean multiThreadingEnabled = DoubletDigger.getMultiThreadingEnabled();

    public DoubletDigger(ClasspathDigger classpathDigger) {
        this.classpathDigger = classpathDigger;
        this.cloader = classpathDigger.getClassLoader();
    }

    protected final void reset() {
        this.doubletList.clear();
    }

    public boolean isDoublet(Class<?> clazz) {
        Boolean doublet = this.doubletClasses.get(clazz);
        if (doublet == null) {
            String classname = clazz.getName();
            String resource = Converter.classToResource(classname);
            try {
                doublet = this.isDoublet(resource);
            }
            catch (NoSuchElementException ex) {
                LOG.trace("{} is not found:", clazz, (Object)ex);
                LOG.debug("{} is a proxy or similar class because classloader does not find it:", clazz);
                doublet = false;
            }
            this.doubletClasses.put(clazz, doublet);
        }
        return doublet;
    }

    public boolean isDoublet(String name) {
        Enumeration<URL> resources = this.classpathDigger.getResources(name);
        if (!resources.hasMoreElements()) {
            throw new NoSuchElementException("resource '" + name + "' not found");
        }
        String rsc = resources.nextElement().toString();
        while (resources.hasMoreElements()) {
            String doublet = resources.nextElement().toString();
            if (rsc.equals(doublet)) continue;
            this.logDoublets(name);
            return true;
        }
        return false;
    }

    public URI getDoublet(String name, int nr) {
        Enumeration<URL> resources = this.classpathDigger.getResources(name);
        int i = 0;
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (i == nr) {
                try {
                    return url.toURI();
                }
                catch (URISyntaxException ex) {
                    LOG.debug("Cannot convert {} to URI:", (Object)url, (Object)ex);
                    return URI.create(url.toString());
                }
            }
            ++i;
        }
        return null;
    }

    public URI getDoublet(Class<?> clazz, int nr) {
        String resource = Converter.classToResource(clazz.getName());
        return this.getDoublet(resource, nr);
    }

    private void logDoublets(String name) {
        if (LOG.isTraceEnabled()) {
            ArrayList<URL> doublets = new ArrayList<URL>();
            Enumeration<URL> resources = this.classpathDigger.getResources(name);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                doublets.add(url);
            }
            LOG.trace("{} doublets found: {}", (Object)name, doublets);
        }
    }

    public String[] getDoubletClasses() {
        LOG.debug("Calculating doublet classes...");
        List<Class<?>> classes = this.getDoubletClassList();
        String[] doublets = new String[classes.size()];
        for (int i = 0; i < doublets.length; ++i) {
            doublets[i] = classes.get(i).toString();
        }
        LOG.debug("Calculating doublet classes successful finished with {} doublet(s) found.", (Object)doublets.length);
        return doublets;
    }

    public String[] getDoubletResources() {
        LOG.debug("Calculating doublet resources...");
        List<String> resources = this.getDoubletResourceList();
        LOG.debug("Calculating doublet classes successful finished with {} doublet(s) found.", (Object)resources.size());
        return resources.toArray(new String[resources.size()]);
    }

    public synchronized List<Class<?>> getDoubletClassList() {
        if (this.multiThreadingEnabled) {
            return this.getDoubletListParallel();
        }
        return this.getDoubletListSerial();
    }

    public synchronized List<String> getDoubletResourceList() {
        List<String> loadedResources = this.classpathDigger.getLoadedResources();
        ArrayList<String> doubletResources = new ArrayList<String>();
        for (String rsc : loadedResources) {
            if (!this.isDoublet(rsc)) continue;
            doubletResources.add(rsc);
        }
        return doubletResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Class<?>> getDoubletListSerial() {
        List<Class<?>> loadedClassList = this.classpathDigger.getLoadedClasses();
        List<Class<?>> list = this.doubletList;
        synchronized (list) {
            for (Class<?> clazz : loadedClassList) {
                if (this.doubletList.contains(clazz)) continue;
                try {
                    if (!this.isDoublet(clazz)) continue;
                    this.doubletList.add(clazz);
                }
                catch (NoSuchElementException nsee) {
                    LOG.trace("{} not found -> ignored:", clazz, (Object)nsee);
                }
            }
            this.sortDoubletList();
        }
        return Collections.unmodifiableList(this.doubletList);
    }

    private void sortDoubletList() {
        try {
            Collections.sort(this.doubletList, new ObjectComparator());
        }
        catch (UnsupportedOperationException ex) {
            LOG.debug("Will sort doubletList with fallback because Collections.sort(..) failed:", (Throwable)ex);
            DoubletDigger.sortList(this.doubletList);
        }
    }

    private static void sortList(List<Class<?>> list) {
        ArrayList sorted = new ArrayList(list.size());
        Collections.sort(sorted, new ObjectComparator());
        list.clear();
        list.addAll(sorted);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.cloader;
    }

    private static boolean getMultiThreadingEnabled() {
        boolean enabled = Boolean.getBoolean(System.getProperty("multiThreadingEnabled", "false"));
        if (enabled) {
            LOG.debug("Multi threading is enabled.");
            return true;
        }
        int n = Runtime.getRuntime().availableProcessors();
        enabled = n > 1;
        LOG.debug("{} processors found, multi threading is {}enabled.", (Object)n, (Object)(enabled ? "" : "not "));
        return enabled;
    }

    public boolean isMultiThreadingEnabled() {
        return this.multiThreadingEnabled;
    }

    public void setMultiThreadingEnabled(boolean enabled) {
        this.multiThreadingEnabled = enabled;
    }

    protected List<Class<?>> getDoubletListParallel() {
        int i;
        List<Class<?>> loadedClassList = this.classpathDigger.getLoadedClasses();
        if (loadedClassList.isEmpty()) {
            return loadedClassList;
        }
        LOG.trace("Creating queue with {} elements for synchronisation.", (Object)loadedClassList.size());
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(loadedClassList);
        Class<?> lastClass = loadedClassList.get(loadedClassList.size() - 1);
        if (this.isDoublet(lastClass)) {
            this.doubletList.add(lastClass);
        }
        LOG.trace("Creating multiple threads.");
        int n = 2;
        List[] l = new List[n];
        DoubletDiggerRunner[] d = new DoubletDiggerRunner[n];
        Thread[] t = new Thread[n];
        for (i = 0; i < n; ++i) {
            l[i] = new ArrayList();
            d[i] = new DoubletDiggerRunner(queue, lastClass, l[i]);
            t[i] = new Thread(d[i]);
            t[i].start();
        }
        LOG.debug("Starting {} threads...", (Object)n);
        for (i = 0; i < n; ++i) {
            try {
                LOG.trace("{} started...", (Object)t[i]);
                t[i].join();
                LOG.trace("{} finished.", (Object)t[i]);
                continue;
            }
            catch (InterruptedException ie) {
                LOG.info("Waiting for {} threads are interrupted:", (Object)n, (Object)ie);
                Thread.currentThread().interrupt();
            }
        }
        LOG.debug("Starting {} threads finished - will add results to doublet list.", (Object)n);
        for (i = 0; i < n; ++i) {
            this.doubletList.addAll(l[i]);
        }
        this.sortDoubletList();
        LOG.trace("Result of {} threads was added to doublet list and sorted.", (Object)n);
        return Collections.unmodifiableList(this.doubletList);
    }

    class DoubletDiggerRunner
    implements Runnable {
        private final Queue<Class<?>> queue;
        private final Class<?> lastClass;
        private final List<Class<?>> newDoublets;

        public DoubletDiggerRunner(Queue<Class<?>> queue, Class<?> lastClass, List<Class<?>> newDoublets) {
            this.queue = queue;
            this.lastClass = lastClass;
            this.newDoublets = newDoublets;
        }

        @Override
        public void run() {
            LOG.debug("Running {}...", (Object)this);
            while (!this.queue.isEmpty()) {
                try {
                    Class<?> clazz = this.queue.remove();
                    if (clazz.equals(this.lastClass)) {
                        LOG.trace("Last {} reached.", clazz);
                        this.queue.add(clazz);
                        break;
                    }
                    if (DoubletDigger.this.doubletList.contains(clazz) || !DoubletDigger.this.isDoublet(clazz)) continue;
                    this.newDoublets.add(clazz);
                }
                catch (NoSuchElementException nsee) {
                    LOG.debug("No element from {} found:", this.queue, (Object)nsee);
                }
            }
            LOG.debug("Running {} finished with {} doublets found.", (Object)this, (Object)this.newDoublets.size());
        }

        public String toString() {
            return "DoubletDigger-" + Thread.currentThread().getId();
        }
    }
}

