/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class ResourceWalker
extends DirectoryWalker<String> {
    private final File startDir;
    private final int startDirnameLength;
    private final Collection<String> dirnames = new ArrayList<String>();

    public ResourceWalker(File dir) {
        this(dir, ResourceWalker.getAllResourcesFilter());
    }

    public ResourceWalker(File dir, String suffix) {
        this(dir, ResourceWalker.getFileFilter(suffix));
    }

    public ResourceWalker(File dir, FileFilter filter) {
        super(filter, -1);
        this.startDir = dir;
        this.startDirnameLength = FilenameUtils.normalizeNoEndSeparator((String)dir.getAbsolutePath()).length();
    }

    private static FileFilter getFileFilter(String suffix) {
        IOFileFilter dirFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), HiddenFileFilter.VISIBLE});
        IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.suffixFileFilter((String)suffix, (IOCase)IOCase.INSENSITIVE)});
        return FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{dirFilter, fileFilter});
    }

    private static FileFilter getAllResourcesFilter() {
        IOFileFilter dirFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), HiddenFileFilter.VISIBLE});
        IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.notFileFilter((IOFileFilter)new RegexFileFilter("^.*\\.class$"))});
        return FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{dirFilter, fileFilter});
    }

    public Collection<String> getResources() throws IOException {
        TreeSet<String> resources = new TreeSet<String>();
        this.walk(this.startDir, resources);
        return resources;
    }

    public Collection<String> getPackages() throws IOException {
        this.dirnames.clear();
        TreeSet dirs = new TreeSet();
        this.walk(this.startDir, dirs);
        ArrayList<String> packages = new ArrayList<String>();
        for (String dirname : this.dirnames) {
            packages.add(dirname.substring(1) + "/");
        }
        return packages;
    }

    protected void handleFile(File file, int depth, Collection<String> results) throws IOException {
        String absFilename = FilenameUtils.normalize((String)file.getAbsolutePath());
        String resource = absFilename.substring(this.startDirnameLength);
        if (!resource.isEmpty()) {
            String normalized = FilenameUtils.separatorsToUnix((String)resource);
            if (file.isDirectory()) {
                this.dirnames.add(normalized);
            } else {
                results.add(normalized);
            }
        }
    }

    protected boolean handleDirectory(File directory, int depth, Collection<String> results) throws IOException {
        super.handleDirectory(directory, depth, results);
        this.handleFile(directory, depth, results);
        return true;
    }
}

