/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.log;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogWatch
extends StopWatch {
    private static final Logger LOG = LoggerFactory.getLogger(LogWatch.class);
    private long nanoStartTime;
    private long nanoEndTime;

    public LogWatch() {
        this.start();
    }

    public void start() {
        this.reset();
        super.start();
        this.nanoStartTime = System.nanoTime();
    }

    public void stop() {
        this.nanoEndTime = System.nanoTime();
        super.stop();
    }

    public void reset() {
        super.reset();
        this.nanoStartTime = 0L;
        this.nanoEndTime = 0L;
    }

    public long getElapsedTime() {
        return this.getTime();
    }

    @Deprecated
    public long getNanoTime() {
        return this.getTimeInNanos();
    }

    public long getTimeInNanos() {
        long endTime = this.nanoEndTime == 0L ? System.nanoTime() : this.nanoEndTime;
        long nanoTime = endTime - this.nanoStartTime;
        if (nanoTime < 0L) {
            long milliTime = this.getTime();
            LOG.info("Will use {} ms as fallback because there was an overflow with nanoTime.", (Object)milliTime);
            nanoTime = 1000000L * milliTime;
        }
        return nanoTime;
    }

    public double getTimeInMillis() {
        return (double)this.getTimeInNanos() / 1000000.0;
    }

    public String toString() {
        double millis = this.getTimeInMillis();
        if (millis > 6000000.0) {
            return super.toString();
        }
        return LogWatch.getTimeAsString(millis, Locale.ENGLISH);
    }

    private static String getTimeAsString(double timeInMillis, Locale locale) {
        if (timeInMillis > 1.0) {
            return LogWatch.getTimeAsString((long)timeInMillis);
        }
        DecimalFormat nf = new DecimalFormat("#.###", new DecimalFormatSymbols(locale));
        return nf.format((Object)timeInMillis) + " ms";
    }

    private static String getTimeAsString(long timeInMillis) {
        if (timeInMillis > 300000L) {
            return (timeInMillis + 30000L) / 60000L + " minutes";
        }
        if (timeInMillis > 5000L) {
            return (timeInMillis + 500L) / 1000L + " seconds";
        }
        return timeInMillis + " ms";
    }
}

