/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.util;

import clazzfish.monitor.io.FileInputStreamReader;
import clazzfish.monitor.util.Converter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger LOG = LoggerFactory.getLogger(Environment.class);
    private static final String FALSE = "false";
    public static final Environment INSTANCE = new Environment();
    public static final String DISABLE_THREADS = "clazzfish.disableThreads";

    protected Environment() {
    }

    public static String getName() {
        String name = Environment.getClassLoader().getClass().getName();
        String[] packages = name.split("[.$]", 4);
        return packages[0] + "." + packages[1] + "." + packages[2];
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        if (cloader == null) {
            cloader = Environment.class.getClassLoader();
            LOG.warn("No ContextClassLoader found - using {}.", (Object)cloader);
        }
        return cloader;
    }

    public static boolean matchesOneOf(String ... props) {
        if (StringUtils.isEmpty((CharSequence)props[0])) {
            LOG.debug("Empty properties are ignored for matching of system properties.");
            return true;
        }
        for (String prop1 : props) {
            String prop;
            if (prop1.contains("*") || prop1.contains("?")) {
                LOG.warn("Wildcard in property \"{}\" is not supported!", (Object)prop1);
            }
            if (FALSE.equalsIgnoreCase(prop = System.getProperty(prop1, FALSE))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyEnabled(String key) {
        String prop = System.getProperty(key, FALSE);
        return !FALSE.equalsIgnoreCase(prop);
    }

    public static Properties loadProperties(String resource) throws IOException {
        ClassLoader cloader = Environment.getClassLoader();
        InputStream istream = cloader.getResourceAsStream(resource);
        if (istream == null && resource.startsWith("/")) {
            istream = cloader.getResourceAsStream(resource.substring(1));
        }
        if (istream == null) {
            LOG.debug("Using Environment.class to get {}...", (Object)resource);
            istream = Environment.class.getResourceAsStream(resource);
        }
        Properties props = Environment.loadProperties(istream);
        istream.close();
        return props;
    }

    public static Properties loadProperties(InputStream istream) throws IOException {
        Properties props = new Properties();
        props.load(istream);
        Properties systemProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            systemProps.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        LOG.debug("{} properties loaded from {}.", (Object)props.size(), (Object)istream);
        return props;
    }

    public static boolean areThreadsAllowed() {
        return !Environment.isGoogleAppEngine() && !Environment.isPropertyEnabled(DISABLE_THREADS);
    }

    public static boolean isGoogleAppEngine() {
        return System.getProperty("com.google.appengine.runtime.version") != null;
    }

    public static boolean isWeblogicServer() {
        return System.getProperty("weblogic.Name") != null;
    }

    public static File getLocalMavenRepositoryDir() throws IOException {
        Object[] repoDirs;
        for (File file : repoDirs = new File[]{Environment.getLocalRepository(), new File(".repository").getAbsoluteFile(), new File("../.repository").getAbsoluteFile()}) {
            if (!file.exists() || !file.isDirectory()) continue;
            return file;
        }
        throw new IOException("local maven repository not found in " + Converter.toString(repoDirs));
    }

    private static File getLocalRepository() {
        File m2Dir = new File(SystemUtils.getUserHome(), ".m2");
        File settings = new File(m2Dir, "settings.xml");
        if (settings.exists()) {
            return Environment.getLocalRepositoryFrom(settings);
        }
        return new File(m2Dir, "repository");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getLocalRepositoryFrom(File settings) {
        File m2Repo = new File(settings.getParentFile(), "repository");
        try (FileInputStreamReader reader = new FileInputStreamReader(settings, StandardCharsets.UTF_8);){
            XMLInputFactory factory = Environment.createXmlInputFactory();
            XMLStreamReader xmlReader = factory.createXMLStreamReader(reader);
            while (xmlReader.next() != 8) {
                QName name;
                if (!xmlReader.isStartElement() || !"localRepository".equalsIgnoreCase((name = xmlReader.getName()).getLocalPart())) continue;
                String content = xmlReader.getElementText();
                File file = new File(content);
                return file;
            }
            LOG.debug("No <localRepository> found in {}.", (Object)settings);
            return m2Repo;
        }
        catch (IOException | XMLStreamException ex) {
            LOG.warn("Will return {} as default because cannot read {}:", new Object[]{m2Repo, settings, ex});
        }
        return m2Repo;
    }

    private static XMLInputFactory createXmlInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return factory;
    }
}

