/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NestedZipFile
extends ZipFile {
    private static final Logger LOG = LoggerFactory.getLogger(NestedZipFile.class);

    public NestedZipFile(String name) throws IOException {
        this(new File(name));
    }

    public NestedZipFile(File file) throws IOException {
        this(file, Charset.defaultCharset());
    }

    public NestedZipFile(File file, int mode) throws IOException {
        this(file, mode, Charset.defaultCharset());
    }

    public NestedZipFile(String name, Charset charset) throws IOException {
        this(new File(name), charset);
    }

    public NestedZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    public NestedZipFile(File file, int mode, Charset charset) throws IOException {
        super(NestedZipFile.getEmbeddedZipFile(file), mode, charset);
    }

    private static File getEmbeddedZipFile(File file) throws IOException {
        String path = file.getPath();
        if (path.contains("!")) {
            String[] pathes = path.split("!");
            return NestedZipFile.getEmbeddedZipFile(new File(pathes[0]), Arrays.copyOfRange(pathes, 1, pathes.length));
        }
        return file;
    }

    private static File getEmbeddedZipFile(File embeddingZip, String[] pathes) throws IOException {
        File embedded = NestedZipFile.getEmbbededZipFile(embeddingZip, pathes[0]);
        if (pathes.length > 1) {
            return NestedZipFile.getEmbeddedZipFile(embedded, Arrays.copyOfRange(pathes, 1, pathes.length));
        }
        return embedded;
    }

    private static File getEmbbededZipFile(File file, String name) throws IOException {
        String normalizedName = FilenameUtils.separatorsToUnix((String)name.substring(1));
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!normalizedName.equals(entry.getName())) continue;
                File file2 = NestedZipFile.getEmbeddedZipFile(zipFile, entry);
                return file2;
            }
        }
        throw new FileNotFoundException("entry '" + name + "' not found in " + file);
    }

    private static File getEmbeddedZipFile(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        try (InputStream istream = zipFile.getInputStream(zipEntry);){
            File tmpZipFile = File.createTempFile(zipEntry.getName(), ".zip");
            tmpZipFile.deleteOnExit();
            FileOutputStream ostream = new FileOutputStream(tmpZipFile);
            IOUtils.copy((InputStream)istream, (OutputStream)ostream);
            ((OutputStream)ostream).close();
            LOG.debug("File {} created with '{}' from file '{}'.", new Object[]{tmpZipFile, zipEntry, zipFile.getName()});
            File file = tmpZipFile;
            return file;
        }
    }

    public String toString() {
        return "ZipFile '" + this.getName() + "'";
    }
}

