/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.util;

import clazzfish.monitor.exception.NotFoundException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class StackTraceScanner {
    private StackTraceScanner() {
    }

    public static Class<?> getCallerClass() {
        return StackTraceScanner.getCallerClass(new Pattern[0]);
    }

    public static Class<?> getCallerClass(Pattern ... excluded) {
        return StackTraceScanner.getCallerClass(excluded, new Class[0]);
    }

    public static Class<?> getCallerClass(Pattern[] excludedMethods, Class<?> ... excludedClasses) {
        StackTraceElement[] stackTrace = StackTraceScanner.getCallerStackTrace(excludedMethods, excludedClasses);
        String classname = stackTrace[0].getClassName();
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new NotFoundException(classname, ex);
        }
    }

    public static StackTraceElement[] getCallerStackTrace() {
        return StackTraceScanner.getCallerStackTrace(new Pattern[0]);
    }

    public static StackTraceElement[] getCallerStackTrace(Pattern ... excluded) {
        return StackTraceScanner.getCallerStackTrace(excluded, new Class[0]);
    }

    public static StackTraceElement[] getCallerStackTrace(Pattern[] excludedMethods, Class<?> ... excludedClasses) {
        int i;
        Object[] stackTrace = Thread.currentThread().getStackTrace();
        String scannerClassName = StackTraceScanner.class.getName();
        for (i = 2; i < stackTrace.length - 1 && scannerClassName.equals(stackTrace[i].getClassName()); ++i) {
        }
        while (i < stackTrace.length - 1 && (StackTraceScanner.matches(stackTrace[i].getMethodName(), excludedMethods) || StackTraceScanner.matches(((StackTraceElement)stackTrace[i]).getClassName(), excludedClasses))) {
            ++i;
        }
        return (StackTraceElement[])ArrayUtils.subarray((Object[])stackTrace, (int)i, (int)stackTrace.length);
    }

    private static boolean matches(String methodName, Pattern ... excluded) {
        for (Pattern anExcluded : excluded) {
            if (!anExcluded.matcher(methodName).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(String className, Class<?> ... excluded) {
        for (Class<?> anExcluded : excluded) {
            if (!className.equals(anExcluded.getName())) continue;
            return true;
        }
        return false;
    }
}

