/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor;

import clazzfish.monitor.AbstractMonitorMBean;
import clazzfish.monitor.internal.Config;
import clazzfish.monitor.io.ExtendedFile;
import clazzfish.monitor.jmx.MBeanFinder;
import clazzfish.monitor.util.ReflectionHelper;
import clazzfish.monitor.util.Shutdowner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonitor
extends Shutdowner
implements AbstractMonitorMBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMonitor.class);
    private ObjectName mbeanName = MBeanFinder.getAsObjectName(this.getClass());

    @Override
    public void run() {
        try {
            File file = this.dumpMe();
            LOG.debug("{} was dumped to '{}'.", (Object)this, (Object)file);
        }
        catch (IOException ioe) {
            LOG.error("Cannot dump {}:", (Object)this, (Object)ioe);
            this.logMe();
        }
        catch (NoClassDefFoundError error) {
            System.err.println("Cannot dump " + String.valueOf(this) + ": " + String.valueOf(error));
        }
    }

    public void registerMeAsMBean() {
        this.registerMeAsMBean(MBeanFinder.getAsObjectName(this.getClass()));
    }

    public void registerMeAsMBean(String name) {
        this.registerMeAsMBean(MBeanFinder.getAsObjectName(name));
    }

    public void registerMeAsMBean(ObjectName name) {
        MBeanFinder.registerMBean(name, (Object)this);
        this.mbeanName = name;
    }

    public void unregisterMeAsMBean() {
        MBeanFinder.unregisterMBean(this.mbeanName);
    }

    public boolean isMBean() {
        return MBeanFinder.isRegistered(this.mbeanName);
    }

    @Override
    public abstract void logMe();

    @Override
    public File getDumpDir() {
        return new File(Config.DEFAULT.getDumpDir(), this.getClass().getSimpleName());
    }

    @Override
    public File dumpMe() throws IOException {
        File dumpDir = this.getDumpDir();
        ExtendedFile.createDir(dumpDir);
        this.dumpMe(dumpDir);
        return dumpDir;
    }

    protected void dump(BufferedWriter writer, String ... getterMethodNames) throws IOException {
        for (String getter : getterMethodNames) {
            this.dumpArray(writer, getter);
        }
        writer.flush();
    }

    protected void dump(File dumpDir, String ... getterMethodNames) throws IOException {
        LOG.debug("Attributes of {} will be dumped to dir '{}'.", this.getClass(), (Object)dumpDir);
        if (!dumpDir.exists()) {
            if (dumpDir.mkdir()) {
                LOG.trace("Directory '{}' successful created.", (Object)dumpDir);
            } else {
                LOG.error("Cannot create dir '{}' and will give up.", (Object)dumpDir);
                return;
            }
        }
        for (String name : getterMethodNames) {
            this.dumpArray(dumpDir, name);
        }
    }

    private void dumpArray(File dir, String title) throws IOException {
        File dumpFile = new File(dir, title + ".txt");
        LOG.debug("Dumping '{}' to {}...", (Object)title, (Object)dumpFile);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), StandardCharsets.UTF_8);){
            this.dumpArray(new BufferedWriter(writer), title);
        }
    }

    private void dumpArray(BufferedWriter writer, String title) throws IOException {
        try {
            Method getter = ReflectionHelper.getMethod(this.getClass(), "get" + title, new Class[0]);
            Object[] array = (Object[])getter.invoke((Object)this, new Object[0]);
            AbstractMonitor.dumpArray(array, writer, title);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new IllegalArgumentException("no accessible getter for '" + title + "' found", ex);
        }
        catch (InvocationTargetException ex) {
            LOG.error("Error happens in getter for '" + title + "':", (Throwable)ex);
            AbstractMonitor.dumpException(writer, ex.getTargetException());
        }
        catch (RuntimeException ex) {
            LOG.error("Cannot get '" + title + "':", (Throwable)ex);
            AbstractMonitor.dumpException(writer, ex);
        }
    }

    private static void dumpException(BufferedWriter writer, Throwable ex) throws IOException {
        writer.write("*** " + String.valueOf(ex));
        writer.newLine();
        ex.printStackTrace(new PrintWriter(writer));
        writer.newLine();
        writer.flush();
    }

    @Override
    public void dumpMe(String dirname) throws IOException {
        this.dumpMe(new File(dirname));
    }

    public void dumpMe(File dumpDir) throws IOException {
        LOG.debug("Attributes of {} will be dumped to dir '{}'.", this.getClass(), (Object)dumpDir);
    }

    protected void copyResource(String name, File file) throws IOException {
        URL readmeURL = this.getClass().getResource(name);
        if (readmeURL == null) {
            throw new IOException("'" + name + "' not found in classpath");
        }
        FileUtils.copyURLToFile((URL)readmeURL, (File)file);
    }

    protected static void dumpArray(Object[] array, File dir, String title) throws IOException {
        File dumpFile = new File(dir, title + ".txt");
        LOG.debug("Dumping '{}' to {}...", (Object)title, (Object)dumpFile);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), StandardCharsets.UTF_8);){
            AbstractMonitor.dumpArray(array, new BufferedWriter(writer), title);
        }
    }

    protected static void dumpArray(Object[] array, BufferedWriter writer, String title) throws IOException {
        AbstractMonitor.dumpHeadline(writer, title + " (" + array.length + " entries)");
        for (Object a : array) {
            writer.write(a.toString());
            writer.newLine();
        }
        AbstractMonitor.dumpHeadline(writer, title + " (end)");
        writer.flush();
    }

    protected static void dumpHeadline(BufferedWriter writer, String headline) throws IOException {
        writer.write("----- " + headline + " -----");
        writer.newLine();
    }

    protected static String[] toStringArray(URI[] uris) {
        Object[] classpath = new String[uris.length];
        for (int i = 0; i < classpath.length; ++i) {
            URI uri = uris[i];
            classpath[i] = uri.getPath();
            if (StringUtils.isEmpty((CharSequence)classpath[i])) {
                classpath[i] = "/" + StringUtils.substringAfter((String)uri.toString(), (String)":/");
            }
            classpath[i] = new File((String)classpath[i]).getAbsolutePath();
        }
        Arrays.sort(classpath);
        return classpath;
    }

    @Override
    public String toString() {
        return this.mbeanName.toString();
    }
}

