/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor;

import clazzfish.monitor.AbstractMonitor;
import clazzfish.monitor.ResourcepathMonitorMBean;
import clazzfish.monitor.internal.DoubletDigger;
import clazzfish.monitor.internal.ResourcepathDigger;
import clazzfish.monitor.jmx.Description;
import clazzfish.monitor.util.ArchivEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcepathMonitor
extends AbstractMonitor
implements ResourcepathMonitorMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcepathMonitor.class);
    private static final Executor EXECUTOR = Executors.newCachedThreadPool();
    private static final ResourcepathMonitor INSTANCE = new ResourcepathMonitor();
    private final ResourcepathDigger resourcepathDigger = ResourcepathDigger.DEFAULT;
    private final DoubletDigger doubletDigger = new DoubletDigger(this.resourcepathDigger);
    private final FutureTask<String[]> resources = this.getFutureResources();

    protected ResourcepathMonitor() {
    }

    private FutureTask<String[]> getFutureResources() {
        Callable<String[]> callable = this::getResourcesArray;
        FutureTask<String[]> resources = new FutureTask<String[]>(callable);
        EXECUTOR.execute(resources);
        return resources;
    }

    public static ResourcepathMonitor getInstance() {
        return INSTANCE;
    }

    public static void registerAsMBean() {
        ResourcepathMonitor.getInstance().registerMeAsMBean();
    }

    public static void unregisterAsMBean() {
        ResourcepathMonitor.getInstance().unregisterMeAsMBean();
    }

    public static boolean isRegisteredAsMBean() {
        return ResourcepathMonitor.getInstance().isMBean();
    }

    @Override
    public String[] getResources() {
        try {
            return this.resources.get();
        }
        catch (ExecutionException ex) {
            LOG.warn("Cannot execute get of {}:", this.resources, (Object)ex);
        }
        catch (InterruptedException ex) {
            LOG.warn("Was interrupted before got result from {}:", this.resources, (Object)ex);
            Thread.currentThread().interrupt();
        }
        return this.getResourcesArray();
    }

    private String[] getResourcesArray() {
        Set<String> resourceSet = this.resourcepathDigger.getResources();
        return resourceSet.toArray(new String[0]);
    }

    @Override
    @Description(value="returns the URI of the given resource")
    public URI whichResource(String name) {
        return this.resourcepathDigger.whichResource(name);
    }

    public Enumeration<URI> getResourcesFor(String name) {
        return this.resourcepathDigger.getResources(name);
    }

    @Override
    public int getNoResources(String name) {
        Enumeration<URI> urls = this.getResourcesFor(name);
        if (urls == null) {
            return 0;
        }
        int n = 0;
        while (urls.hasMoreElements()) {
            ++n;
            urls.nextElement();
        }
        LOG.trace("{} element(s) of {} found in classpath.", (Object)n, (Object)name);
        return n;
    }

    @Override
    @Description(value="is the given classname or resource found more than once in the classpath?")
    public boolean isDoublet(String name) {
        return this.doubletDigger.isDoublet(name);
    }

    @Override
    @Description(value="returns the first doublet of the given classname or resource")
    public URI getFirstDoublet(String name) {
        return this.getDoublet(name, 1);
    }

    @Override
    public URI getDoublet(String name, int nr) {
        return this.doubletDigger.getDoublet(name, nr);
    }

    @Override
    public String[] getDoublets() {
        ArrayList<String> doublets = new ArrayList<String>();
        for (String resource : this.getResources()) {
            try {
                if ("/META-INF/MANIFEST.MF".equals(resource) || !this.isDoublet(resource)) continue;
                doublets.add(resource);
            }
            catch (NoSuchElementException ex) {
                LOG.debug("'{}' is ignored as resource ({})", (Object)resource, (Object)ex.getMessage());
                LOG.trace("Details:", (Throwable)ex);
            }
        }
        return doublets.toArray(new String[0]);
    }

    @Override
    @Description(value="returns the classpath where doublets were found")
    public String[] getDoubletResourcepath() {
        URI[] resourcepathURIs = this.getDoubletResourcepathURIs();
        return ResourcepathMonitor.toStringArray(resourcepathURIs);
    }

    protected URI[] getDoubletResourcepathURIs() {
        LOG.trace("Calculating doublet-resourcepath.");
        ArrayList<String> doubletsWithoutMetaInf = new ArrayList<String>();
        for (String doublet : this.getDoublets()) {
            if ("/META-INF/MANIFEST.MF".equals(doublet)) continue;
            doubletsWithoutMetaInf.add(doublet);
        }
        SortedSet<URI> resourcepathSet = this.resourcepathDigger.getResourcepathSet(doubletsWithoutMetaInf);
        return resourcepathSet.toArray(new URI[0]);
    }

    @Override
    public String[] getIncompatibleResources() {
        ArrayList<String> incompatibleResources = new ArrayList<String>();
        block2: for (String rsc : this.getDoublets()) {
            Enumeration<URI> doubletURLs = this.getResourcesFor(rsc);
            try {
                URI url = doubletURLs.nextElement();
                ArchivEntry archivEntry = new ArchivEntry(url);
                while (doubletURLs.hasMoreElements()) {
                    url = doubletURLs.nextElement();
                    ArchivEntry doubletEntry = new ArchivEntry(url);
                    if (!archivEntry.equals(doubletEntry)) continue;
                    incompatibleResources.add(rsc);
                    continue block2;
                }
            }
            catch (NoSuchElementException nse) {
                LOG.warn("{} is not added to incompatible resource list:", (Object)rsc, (Object)nse);
            }
        }
        return incompatibleResources.toArray(new String[0]);
    }

    @Override
    public String[] getIncompatibleResourcepath() {
        URI[] resourcepathURIs = this.getIncompatibleResourcepathURIs();
        return ResourcepathMonitor.toStringArray(resourcepathURIs);
    }

    protected URI[] getIncompatibleResourcepathURIs() {
        ArrayList<String> resourcesWithoutMetainf = new ArrayList<String>();
        for (String resource : this.getIncompatibleResources()) {
            if (resource.startsWith("/META-INF")) continue;
            resourcesWithoutMetainf.add(resource);
        }
        SortedSet<URI> resourcepathSet = this.resourcepathDigger.getResourcepathSet(resourcesWithoutMetainf);
        return resourcepathSet.toArray(new URI[0]);
    }

    @Override
    public void logMe() {
        try {
            StringWriter writer = new StringWriter();
            ResourcepathMonitor.dumpArray((Object[])this.getResources(), new BufferedWriter(writer), "resources");
            LOG.info(writer.toString());
        }
        catch (IOException cannothappen) {
            LOG.warn("Cannot dump resources:", (Throwable)cannothappen);
        }
    }

    @Override
    public void dumpMe(File dumpDir) throws IOException {
        super.dumpMe(dumpDir);
        this.dump(dumpDir, "DoubletResourcepath", "DoubletResourcepathURIs", "Doublets", "IncompatibleResources", "IncompatibleResourcepath", "IncompatibleResourcepathURIs", "Resources");
        this.copyResource("RscMonREADME.txt", new File(dumpDir, "README.txt"));
    }
}

