/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor;

import clazzfish.monitor.ClasspathMonitor;
import clazzfish.monitor.ResourcepathMonitor;
import clazzfish.monitor.internal.Config;
import clazzfish.monitor.stat.ClazzStatistic;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Starter {
    private static final Logger log = LoggerFactory.getLogger(Starter.class);

    public static void start() {
        ClasspathMonitor.getInstance().registerMeAsMBean();
        ResourcepathMonitor.getInstance().registerMeAsMBean();
        ClazzStatistic.getInstance().registerMeAsMBean();
        log.debug("ClazzFish library is started and ready.");
    }

    public static void record() {
        Starter.start();
        ClazzStatistic.getInstance().addMeAsShutdownHook();
        log.trace("ClazzStatistic MBeans is registered as shutdown hook.");
    }

    public static void recordAll() {
        Starter.record();
        ClasspathMonitor.getInstance().addMeAsShutdownHook();
        ResourcepathMonitor.getInstance().addMeAsShutdownHook();
        log.trace("All MBeans are registered as shutdown hook.");
    }

    public static void record(File dir) {
        Config.DEFAULT.setDumpDir(dir);
        Starter.record();
    }

    public static void recordAll(File dir) {
        Config.DEFAULT.setDumpDir(dir);
        Starter.recordAll();
    }
}

