/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.internal;

import clazzfish.monitor.internal.ClassDiagnostic;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.PackageInfoList;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoringClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(BoringClassLoader.class);
    private final Map<String, Class<?>> loadedClasses = new HashMap();
    private String[] packageNames = new String[0];
    private final SortedSet<URI> usedClasspath = new TreeSet<URI>();
    public static BoringClassLoader DEFAULT_CLOADER = new BoringClassLoader();
    public static BoringClassLoader SYSTEM_CLOADER = new BoringClassLoader(BoringClassLoader.getSystemClassLoader());

    public static BoringClassLoader of(ClassLoader classLoader) {
        if (classLoader instanceof BoringClassLoader) {
            return (BoringClassLoader)classLoader;
        }
        return new BoringClassLoader(classLoader);
    }

    private BoringClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    private BoringClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Set<String> getAllPackageNames() {
        HashSet<String> packageNames;
        try (ScanResult scanResult = new ClassGraph().enableExternalClasses().verbose(log.isTraceEnabled()).scan();){
            PackageInfoList packageInfos = scanResult.getPackageInfo();
            packageNames = new HashSet<String>(packageInfos.getNames());
        }
        for (Package pkg : this.getPackages()) {
            packageNames.add(pkg.getName());
        }
        packageNames.remove("");
        return packageNames;
    }

    public Set<String> getUnusedPackageNames() {
        Set<String> packageNames = this.getAllPackageNames();
        for (Package pkg : this.getPackages()) {
            packageNames.remove(pkg.getName());
        }
        return packageNames;
    }

    public Set<Class<?>> getLoadedClasses() {
        String classname = this.getClass().getName();
        if (this.findLoadedClass(classname) == null) {
            log.trace("Using fallback to find loaded classes because parent does not find not {} as loaded class.", (Object)classname);
            return new HashSet(ClassDiagnostic.getLoadedClassesFromGC());
        }
        HashSet loadedClassSet = new HashSet();
        String[] packageNames = this.getPackageNames();
        log.debug("{} packages found.", (Object)packageNames.length);
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().acceptPackages(packageNames).verbose(log.isTraceEnabled()).scan();){
            ClassInfoList list = scanResult.getAllClasses();
            for (ClassInfo info : list) {
                classname = info.getName();
                try {
                    Class<?> loaded = BoringClassLoader.getLoadedClass(classname);
                    if (loaded == null) {
                        loaded = this.findClass(classname);
                    }
                    if (loaded == null) continue;
                    loadedClassSet.add(loaded);
                }
                catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError | UnsatisfiedLinkError ex) {
                    log.debug("'{}' is not found as class ({}).", (Object)classname, (Object)ex.getMessage());
                    log.trace("Details:", ex);
                }
            }
        }
        return loadedClassSet;
    }

    private static Class<?> getLoadedClass(String classname) {
        Class<?> loaded = SYSTEM_CLOADER.findLoadedClass(classname);
        if (loaded == null) {
            loaded = DEFAULT_CLOADER.findLoadedClass(classname);
        }
        return loaded;
    }

    public SortedSet<URI> getUsedClassspath() {
        if (this.usedClasspath.isEmpty()) {
            String[] packageNames = this.getPackageNames();
            try (ScanResult scanResult = new ClassGraph().acceptPackages(packageNames).verbose(log.isTraceEnabled()).scan();){
                ResourceList rscList = scanResult.getAllResources();
                for (Resource rsc : rscList) {
                    this.usedClasspath.add(rsc.getClasspathElementURI());
                }
            }
        }
        return this.usedClasspath;
    }

    private String[] getPackageNames() {
        Package[] packages = super.getPackages();
        if (packages.length != this.packageNames.length) {
            this.packageNames = (String[])Arrays.stream(packages).map(Package::getName).toArray(String[]::new);
            this.usedClasspath.clear();
        }
        return this.packageNames;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> found = this.loadedClasses.get(name);
        if (found != null) {
            return found;
        }
        try {
            found = super.findClass(name);
            this.loadedClasses.put(name, found);
        }
        catch (ClassNotFoundException ex) {
            log.debug("Class '{}' was not found by superclass.", (Object)name);
            log.trace("Details:", (Throwable)ex);
        }
        return found;
    }
}

