/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.internal;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassDiagnostic {
    private static final Logger log = LoggerFactory.getLogger(ClassDiagnostic.class);

    public static List<Class<?>> getLoadedClassesFromGC() {
        String mbeanName = "com.sun.management:type=DiagnosticCommand";
        try {
            Object classHistogram = ManagementFactory.getPlatformMBeanServer().invoke(new ObjectName(mbeanName), "gcClassHistogram", new Object[]{new String[]{"-all"}}, new String[]{"[Ljava.lang.String;"});
            return ClassDiagnostic.parseClassHistogramm(classHistogram.toString());
        }
        catch (JMException ex) {
            log.warn("Cannot call 'getLoadedClasses(..)' from MBean \"{}\"", (Object)mbeanName, (Object)ex);
            return new ArrayList();
        }
    }

    private static List<Class<?>> parseClassHistogramm(String histogram) {
        ArrayList classes = new ArrayList();
        String[] lines = histogram.split("\n");
        for (int i = 2; i < lines.length - 1; ++i) {
            String[] parts = lines[i].trim().split("\\s+");
            String className = parts[3];
            if (ClassDiagnostic.isNotRealClass(className)) {
                log.trace("'{}' is ignored because it is not a real class name.", classes);
                continue;
            }
            try {
                Class<?> cl = Class.forName(className);
                classes.add(cl);
                continue;
            }
            catch (ClassNotFoundException ex) {
                log.debug("Class '{}' could not be loaded ({}).", (Object)className, (Object)ex.getMessage());
                log.trace("Details:", (Throwable)ex);
            }
        }
        return classes;
    }

    private static boolean isNotRealClass(String className) {
        return className.contains("$$Lambda$") || className.startsWith("jdk.internal.reflect.Generated");
    }
}

