/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.internal;

import clazzfish.monitor.ClassloaderType;
import clazzfish.monitor.exception.NotFoundException;
import clazzfish.monitor.internal.AbstractDigger;
import clazzfish.monitor.internal.BoringClassLoader;
import clazzfish.monitor.internal.ClassDiagnostic;
import clazzfish.monitor.internal.ClassWalker;
import clazzfish.monitor.internal.ResourcepathDigger;
import clazzfish.monitor.io.ExtendedFile;
import clazzfish.monitor.jmx.MBeanFinder;
import clazzfish.monitor.util.ClasspathHelper;
import clazzfish.monitor.util.Converter;
import clazzfish.monitor.util.ReflectionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ReflectionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathDigger
extends AbstractDigger {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathDigger.class);
    private static final String[] AGENT_MBEAN_NAMES = new String[]{"clazzfish:type=agent,agent=ClasspathAgent", "clazzfish.agent:type=ClasspathAgent"};
    private static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private final ClassLoader classLoader;
    private final String[] bootClassPath = ClasspathDigger.getClasspath("sun.boot.class.path");
    private final ObjectInstance agentMBean;
    public static final ClasspathDigger DEFAULT = new ClasspathDigger();

    public ClasspathDigger() {
        this(ClasspathDigger.getContextClassLoader());
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        if (cloader == null) {
            cloader = ClasspathDigger.class.getClassLoader();
            LOG.warn("No ContextClassLoader found - using now {}.", (Object)cloader);
        }
        return cloader;
    }

    public ClasspathDigger(ClassLoader cloader) {
        this.classLoader = cloader;
        this.agentMBean = MBeanFinder.findMBean(AGENT_MBEAN_NAMES);
        if (this.agentMBean == null && LOG.isDebugEnabled()) {
            LOG.debug("No MBean \"{}\" found - be sure to call ClazzFish as agent (e.g. 'java -javaagent:clazzfish-agent-2.2.jar...')", (Object)Arrays.toString(AGENT_MBEAN_NAMES));
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isClassloaderSupported() {
        return ClassloaderType.isSupported(this.classLoader.getClass().getName());
    }

    public static boolean isAgentAvailable() {
        return MBeanFinder.findMBean(AGENT_MBEAN_NAMES) != null;
    }

    public String[] getBootClasspath() {
        return this.bootClassPath;
    }

    public String[] getClasspath() {
        try {
            switch (ClassloaderType.toClassloaderType(this.classLoader)) {
                case NET: {
                    return this.getNetClasspath();
                }
                case TOMCAT: {
                    return this.getTomcatClasspath();
                }
                case TOMCAT8: {
                    return this.getTomcat8Classpath();
                }
                case WEBLOGIC: {
                    return this.getWeblogicClasspath();
                }
                case WEBSPHERE: {
                    return this.getWebsphereClasspath();
                }
            }
            LOG.trace("using 'java.class.path' to get classpath...");
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Will fallback to 'java.class.path' because cannot get classpath from {}:", (Object)this.classLoader, (Object)ex);
        }
        return ClasspathDigger.getClasspath("java.class.path");
    }

    private String[] getNetClasspath() {
        URLClassLoader netloader = (URLClassLoader)this.classLoader;
        return ClasspathDigger.getAsClasspath(netloader.getURLs());
    }

    private String[] getTomcatClasspath() {
        URL[] repositoryURLs = (URL[])ClassloaderType.TOMCAT.getClasspathFrom(this.classLoader);
        return ClasspathDigger.getAsClasspath(repositoryURLs);
    }

    private String[] getTomcat8Classpath() {
        List repositoryURLs = (List)ClassloaderType.TOMCAT8.getClasspathFrom(this.classLoader);
        return ClasspathDigger.getAsClasspath(repositoryURLs);
    }

    private static String[] getAsClasspath(List<URL> repositoryURLs) {
        return ClasspathDigger.getAsClasspath(repositoryURLs.toArray(new URL[0]));
    }

    private static String[] getAsClasspath(URL[] repositoryURLs) {
        String[] cp = new String[repositoryURLs.length];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = Converter.toAbsolutePath(Converter.toURI(repositoryURLs[i]));
        }
        return cp;
    }

    private String[] getWeblogicClasspath() {
        return this.getClasspathFromPackages();
    }

    private String[] getWebsphereClasspath() {
        String localClassPath = (String)ClassloaderType.WEBSPHERE.getClasspathFrom(this.classLoader);
        String[] classpath = ClasspathDigger.splitClasspath(localClassPath);
        ArrayList<File> files = new ArrayList<File>(classpath.length);
        ArrayList<File> toBeRemoved = new ArrayList<File>(classpath.length);
        File webinfClasses = new File("WEB-INF", "classes");
        for (String s : classpath) {
            ExtendedFile f = new ExtendedFile(s);
            files.add(f);
            if (!f.endsWith(webinfClasses)) continue;
            toBeRemoved.add(f.getBaseDir(webinfClasses));
        }
        for (File file : toBeRemoved) {
            files.remove(file);
        }
        return ExtendedFile.toStringArray(files);
    }

    protected static String[] getClasspath(String key) {
        String classpath = System.getProperty(key);
        if (classpath == null) {
            LOG.trace("{} is not set (not a SunVM or JDK 9+)", (Object)key);
            return new String[0];
        }
        String[] cp = ClasspathDigger.splitClasspath(classpath);
        return ClasspathDigger.validatedClasspath(cp);
    }

    private static String[] splitClasspath(String classpath) {
        String[] cp = StringUtils.split((String)classpath, (String)File.pathSeparator);
        for (int i = 0; i < cp.length; ++i) {
            if (!cp[i].endsWith(File.separator)) continue;
            cp[i] = cp[i].substring(0, cp[i].length() - 1);
        }
        return cp;
    }

    private static String[] validatedClasspath(String[] classpathes) {
        ArrayList<String> validated = new ArrayList<String>();
        for (String name : classpathes) {
            File path = new File(name);
            if (name.contains("!") || path.exists()) {
                validated.add(name);
                continue;
            }
            LOG.debug("'{}' in classpath is ignored because it does not exists.", (Object)path);
        }
        return validated.toArray(new String[0]);
    }

    public String[] getPackageArray() {
        Collection<String> packages = this.getPackages();
        return packages.toArray(new String[0]);
    }

    private Collection<String> getPackages() {
        TreeSet<String> packages = new TreeSet<String>();
        BoringClassLoader bcl = BoringClassLoader.of(this.classLoader);
        for (String name : bcl.getAllPackageNames()) {
            packages.add(Converter.packageToResource(name) + "/");
        }
        return packages;
    }

    private static void addElementsFromArchive(Collection<String> elements, File archive, String suffix) throws IOException {
        Collection<String> allElements = ClasspathDigger.readElementsFromNestedArchive(archive);
        for (String resource : allElements) {
            if (!resource.endsWith(suffix)) continue;
            elements.add(Converter.resourceToClass(resource));
        }
    }

    public Package[] getLoadedPackageArray() {
        return Package.getPackages();
    }

    protected String[] getClasspathFromPackages() {
        Package[] packages;
        LinkedHashSet<URI> packageURIs = new LinkedHashSet<URI>();
        for (Package aPackage : packages = this.getLoadedPackageArray()) {
            String resource = Converter.toResource(aPackage);
            URI uri = ResourcepathDigger.whichResource(resource, this.classLoader);
            if (uri == null) continue;
            URI path = ClasspathHelper.getParent(uri, resource);
            packageURIs.add(path);
        }
        return this.getClasspathFromPackages(packageURIs);
    }

    private String[] getClasspathFromPackages(Set<URI> packages) {
        String[] classpath = new String[packages.size()];
        Iterator<URI> iterator = packages.iterator();
        for (int i = 0; i < classpath.length; ++i) {
            URI uri = iterator.next();
            classpath[i] = Converter.toAbsolutePath(uri);
        }
        return classpath;
    }

    @Override
    public Enumeration<URI> getResources(String name) {
        try {
            Enumeration<URL> resources = this.classLoader.getResources(name);
            if (!resources.hasMoreElements()) {
                LOG.trace("Resource '{}' not found in classpath", (Object)name);
                if (name.startsWith("/")) {
                    return this.getResources(name.substring(1));
                }
            }
            Set<URI> resourceSet = ClasspathDigger.asURIs(resources);
            return new Vector<URI>(resourceSet).elements();
        }
        catch (IOException ioe) {
            throw new NotFoundException("resource '" + name + "' not found in classpath", ioe);
        }
    }

    private static Set<URI> asURIs(Enumeration<URL> enums) {
        HashSet<URI> set = new HashSet<URI>();
        while (enums.hasMoreElements()) {
            set.add(Converter.toURI(enums.nextElement()));
        }
        return set;
    }

    public SortedSet<URI> getResourcepathSet(Collection<String> resources) {
        TreeSet<URI> rscPath = new TreeSet<URI>();
        for (String rsc : resources) {
            Enumeration<URI> urls = this.getResources(rsc);
            while (urls.hasMoreElements()) {
                URI path = urls.nextElement();
                rscPath.add(ClasspathHelper.getParent(path, rsc));
            }
        }
        return rscPath;
    }

    public URI whichResource(String name) {
        return ResourcepathDigger.whichResource(name, this.classLoader);
    }

    public boolean isLoaded(String classname) {
        for (Class<?> loaded : this.getLoadedClasses()) {
            if (!classname.equals(loaded.getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ClasspathDigger for " + String.valueOf(this.classLoader);
    }

    public List<Class<?>> getLoadedClasses() {
        List<Class<Object>> loadedClasses = new ArrayList();
        if (this.agentMBean != null) {
            try {
                loadedClasses = this.getLoadedClassListFrom(this.agentMBean);
            }
            catch (JMException ex) {
                LOG.debug("Cannot get loaded classes with {} ({}).", (Object)this.agentMBean, (Object)ex.getMessage());
                LOG.trace("Details:", (Throwable)ex);
                loadedClasses = ClassDiagnostic.getLoadedClassesFromGC();
            }
        }
        if (loadedClasses.isEmpty()) {
            try {
                Field field = ReflectionHelper.getField(this.classLoader.getClass(), "classes");
                loadedClasses = (List)field.get(this.classLoader);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                LOG.debug("Cannot access field 'classes' of {}.", (Object)this.classLoader);
                LOG.trace("Details:", (Throwable)ex);
                loadedClasses = ClasspathDigger.getLoadedClassesFrom(Thread.currentThread().getContextClassLoader());
            }
        }
        return loadedClasses;
    }

    private static List<Class<?>> getLoadedClassesFrom(ClassLoader classLoader) {
        BoringClassLoader bcl = BoringClassLoader.of(classLoader);
        return new ArrayList(bcl.getLoadedClasses());
    }

    private List<Class<?>> getLoadedClassListFrom(ObjectInstance agent) throws ReflectionException, InstanceNotFoundException, MBeanException {
        Class[] classes = (Class[])MBEAN_SERVER.invoke(agent.getObjectName(), "getLoadedClasses", new Object[]{this.getClass().getClassLoader()}, new String[]{ClassLoader.class.getName()});
        return Arrays.asList(classes);
    }

    public List<String> getLoadedResources() {
        List<String> resources = this.getLoadedResourcesOf("/");
        for (Package pkg : this.getLoadedPackageArray()) {
            String packageResource = "/" + pkg.getName().replaceAll("\\.", "/") + "/";
            resources.addAll(this.getLoadedResourcesOf(packageResource));
        }
        return resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getLoadedResourcesOf(String packageResource) {
        ArrayList<String> loadedResources = new ArrayList<String>();
        String packageResourceWithoutSlash = packageResource.substring(1);
        try (InputStream istream = this.classLoader.getResourceAsStream(packageResourceWithoutSlash);){
            if (istream == null) {
                LOG.trace("Cannot load '{}' with {}.", (Object)packageResource, (Object)this.classLoader);
                ArrayList<String> arrayList = loadedResources;
                return arrayList;
            }
            List lines = IOUtils.readLines((InputStream)istream, (Charset)StandardCharsets.UTF_8);
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                String resource = packageResource + line;
                if (!ClasspathDigger.isNormalResource(resource)) continue;
                loadedResources.add(resource);
            }
            return loadedResources;
        }
        catch (IOException ioe) {
            LOG.warn("Cannot get resources for package '{}':", (Object)packageResource, (Object)ioe);
        }
        return loadedResources;
    }

    private static boolean isNormalResource(String resource) {
        return resource.contains(".") && !resource.endsWith(".class");
    }

    public Set<String> getClasses() {
        TreeSet<String> classSet = new TreeSet<String>();
        for (String path : this.getClasspath()) {
            ClasspathDigger.addClasses(classSet, new File(path));
        }
        return classSet;
    }

    private static void addClasses(Set<String> classSet, File path) {
        LOG.trace("Adding classes from {}...", (Object)path);
        try {
            if (path.isDirectory()) {
                ClasspathDigger.addClassesFromDir(classSet, path);
            } else {
                ClasspathDigger.addElementsFromArchive(classSet, path, ".class");
            }
        }
        catch (IOException ioe) {
            LOG.warn("Cannot add classes from " + path.getAbsolutePath() + ":", (Throwable)ioe);
        }
    }

    private static void addClassesFromDir(Set<String> classSet, File dir) throws IOException {
        ClassWalker classWalker = new ClassWalker(dir);
        Collection<String> classes = classWalker.getClasses();
        classSet.addAll(classes);
    }
}

