/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.internal;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private File dumpDir;
    public static Config DEFAULT = new Config();

    private Config() {
        this(Config.findDumpDir());
    }

    private Config(File dumpDir) {
        this.dumpDir = dumpDir;
    }

    public static String getEnvironment(String key) {
        String value = System.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            String envKey = key.replace('.', '_').toUpperCase();
            log.debug("System property '{}' is not set, trying environment variable '{}'.", (Object)key, (Object)envKey);
            value = System.getenv(envKey);
        }
        return value;
    }

    public File getDumpDir() {
        return this.dumpDir;
    }

    public void setDumpDir(File dir) {
        if (!Objects.equals(dir, this.dumpDir)) {
            this.dumpDir = dir;
            log.info("Dump directory is set to '{}'.", (Object)dir);
        }
    }

    private static File findDumpDir() {
        String dirname = Config.getEnvironment("clazzfish.dump.dir");
        if (StringUtils.isNotBlank((CharSequence)dirname)) {
            return new File(dirname);
        }
        File dir = new File(SystemUtils.getJavaIoTmpDir(), "ClazzFish");
        return new File(dir, Config.getAppName());
    }

    private static String getAppName() {
        String[] keys = new String[]{"appname", "app.name", "progname", "prog.name", "application.name", "spring.application.name"};
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            for (String k : keys) {
                if (!k.equals(entry.getKey().toString().toLowerCase())) continue;
                log.debug("Using {} for name of CSV file.", entry);
                return entry.getValue().toString();
            }
        }
        log.trace("Using main class as application name.");
        return Config.getStartClassname();
    }

    private static String getStartClassname() {
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> trace : traces.entrySet()) {
            if (!"main".equals(trace.getKey().getName())) continue;
            StackTraceElement[] els = trace.getValue();
            for (int i = els.length - 1; i >= 0; --i) {
                String cls = els[i].getClassName();
                if (Config.isSystemClass(cls)) continue;
                return cls;
            }
            return els[els.length - 1].getClassName();
        }
        return "unknown";
    }

    private static boolean isSystemClass(String cls) {
        return cls.startsWith("java.") || cls.startsWith("jdk.") || cls.startsWith("sun.") || cls.startsWith("org.apache.maven.") || cls.contains(".intellij.") || cls.startsWith("org.junit") || cls.startsWith("junit.") || cls.contains(".eclipse") || cls.contains("netbeans");
    }
}

