/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.jmx;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanFinder {
    private static final Logger log = LoggerFactory.getLogger(MBeanFinder.class);
    private static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();

    private MBeanFinder() {
    }

    public static String getMBeanName(Object mbean) {
        return MBeanFinder.getMBeanName(mbean.getClass());
    }

    public static String getMBeanName(Class<?> cl) {
        return MBeanFinder.getMBeanName(cl, 1);
    }

    public static String getMBeanName(Class<?> cl, int level) {
        assert (level > 0) : "level must be 1 or greater";
        String packageName = cl.getPackage().getName();
        String mbeanName = MBeanFinder.getAsMBeanType(level, packageName);
        return mbeanName + ",name=" + cl.getSimpleName();
    }

    public static String getMBeanName(String name) {
        if (name.contains(":")) {
            return name;
        }
        if (name.contains(".")) {
            String packageName = StringUtils.substringBeforeLast((String)name, (String)".");
            return MBeanFinder.getAsMBeanType(1, packageName) + ",name=" + StringUtils.substringAfterLast((String)name, (String)".");
        }
        return ":name=" + name;
    }

    private static String getAsMBeanType(int level, String packageName) {
        String[] names = StringUtils.split((String)packageName, (String)".");
        int n = level >= names.length ? names.length - 1 : level;
        StringBuilder domain = new StringBuilder(names[0]);
        for (int i = 1; i < n; ++i) {
            domain.append(".");
            domain.append(names[i]);
        }
        String type = names[n];
        StringBuilder mbeanName = new StringBuilder(domain);
        mbeanName.append(":type=");
        mbeanName.append(type);
        for (int i = n + 1; i < names.length; ++i) {
            mbeanName.append(",").append(names[i - 1]).append("=").append(names[i]);
        }
        return mbeanName.toString();
    }

    public static ObjectName getAsObjectName(String name) {
        try {
            return new ObjectName(MBeanFinder.getMBeanName(name));
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException("illegal name: " + name, ex);
        }
    }

    public static ObjectName getAsObjectName(Class<?> mbeanClass) {
        String name = MBeanFinder.getMBeanName(mbeanClass);
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException("'" + name + "' cannot be transformed to an ObjectName", ex);
        }
    }

    public static void registerMBean(Object mbean) {
        String mbeanName = MBeanFinder.getMBeanName(mbean);
        MBeanFinder.registerMBean(mbeanName, mbean);
    }

    public static synchronized void registerMBean(String mbeanName, Object mbean) {
        try {
            ObjectName name = new ObjectName(mbeanName);
            MBeanFinder.registerMBean(name, mbean);
        }
        catch (MalformedObjectNameException ex) {
            log.info("Cannot register '{}' as MBean:", mbean, (Object)ex);
        }
    }

    public static synchronized void registerMBean(ObjectName name, Object mbean) {
        try {
            log.trace("Registering '{}'...", (Object)name);
            MBEAN_SERVER.registerMBean(mbean, name);
            log.debug("'{}' successful registered as MBean", (Object)name);
        }
        catch (InstanceAlreadyExistsException ex) {
            log.debug("'{}' is already registered.", (Object)name);
            log.trace("Details:", (Throwable)ex);
        }
        catch (MBeanRegistrationException ex) {
            log.info("Cannot register <{}> as MBean:", mbean, (Object)ex);
        }
        catch (NotCompliantMBeanException ex) {
            log.info("<{}> is not a compliant MBean:", mbean, (Object)ex);
        }
    }

    public static synchronized void unregisterMBean(ObjectName name) {
        try {
            MBEAN_SERVER.unregisterMBean(name);
            log.debug("MBean " + String.valueOf(name) + " successful unregistered");
        }
        catch (MBeanRegistrationException ex) {
            log.info("Cannot unregister '" + String.valueOf(name) + "':", (Throwable)ex);
        }
        catch (InstanceNotFoundException ex) {
            log.info("'" + String.valueOf(name) + "' not found:", (Throwable)ex);
        }
    }

    public static boolean isRegistered(String mbeanName) {
        ObjectName name = MBeanFinder.getAsObjectName(mbeanName);
        return MBeanFinder.isRegistered(name);
    }

    public static boolean isRegistered(ObjectName name) {
        try {
            ObjectInstance mbean = MBEAN_SERVER.getObjectInstance(name);
            return mbean != null;
        }
        catch (InstanceNotFoundException ex) {
            log.trace("'" + String.valueOf(name) + "' not found:", (Throwable)ex);
            return false;
        }
    }

    public static TabularDataSupport createTabularDataSupport(CompositeType rowType, String[] itemNames) throws OpenDataException {
        TabularType tabularType = new TabularType("propertyTabularType", "properties tabular", rowType, itemNames);
        return new TabularDataSupport(tabularType);
    }

    public static ObjectInstance findMBean(String ... mbeanNames) {
        for (String name : mbeanNames) {
            try {
                ObjectName objectName = new ObjectName(name);
                return MBEAN_SERVER.getObjectInstance(objectName);
            }
            catch (InstanceNotFoundException | MalformedObjectNameException ex) {
                log.debug("'{}' is not registered as MBean ({}).", (Object)name, (Object)ex.getMessage());
                log.trace("Details:", (Throwable)ex);
            }
        }
        log.debug("No MBean \"{}\" found.", (Object)Arrays.toString(mbeanNames));
        return null;
    }
}

