/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.jmx;

import java.lang.management.ManagementFactory;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class MBeanHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanHelper.class);
    private static final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    private MBeanHelper() {
    }

    public static String getMBeanName(Object mbean) {
        return MBeanHelper.getMBeanName(mbean.getClass());
    }

    public static String getMBeanName(Object mbean, int level) {
        return MBeanHelper.getMBeanName(mbean.getClass(), level);
    }

    public static String getMBeanName(Class<?> cl) {
        return MBeanHelper.getMBeanName(cl, 2);
    }

    public static String getMBeanName(Class<?> cl, int level) {
        assert (level > 0) : "level must be 1 or greater";
        String packageName = cl.getPackage().getName();
        String mbeanName = MBeanHelper.getAsMBeanType(level, packageName);
        return mbeanName + ",name=" + cl.getSimpleName();
    }

    public static String getMBeanName(String name) {
        if (name.contains(":")) {
            return name;
        }
        if (name.contains(".")) {
            String packageName = StringUtils.substringBeforeLast((String)name, (String)".");
            return MBeanHelper.getAsMBeanType(1, packageName) + ",name=" + StringUtils.substringAfterLast((String)name, (String)".");
        }
        return ":name=" + name;
    }

    private static String getAsMBeanType(int level, String packageName) {
        String[] names = StringUtils.split((String)packageName, (String)".");
        int n = level >= names.length ? names.length - 1 : level;
        StringBuilder domain = new StringBuilder(names[0]);
        for (int i = 1; i < n; ++i) {
            domain.append(".");
            domain.append(names[i]);
        }
        String type = names[n];
        StringBuilder mbeanName = new StringBuilder(domain);
        mbeanName.append(":type=");
        mbeanName.append(type);
        for (int i = n + 1; i < names.length; ++i) {
            mbeanName.append(",").append(names[i - 1]).append("=").append(names[i]);
        }
        return mbeanName.toString();
    }

    public static ObjectName getAsObjectName(String name) {
        try {
            return new ObjectName(MBeanHelper.getMBeanName(name));
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException("illegal name: " + name, ex);
        }
    }

    public static ObjectName getAsObjectName(Class<?> mbeanClass) {
        String name = MBeanHelper.getMBeanName(mbeanClass);
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException("'" + name + "' cannot be transformed to an ObjectName", ex);
        }
    }

    public static void registerMBean(Object mbean) throws JMException {
        String mbeanName = MBeanHelper.getMBeanName(mbean);
        MBeanHelper.registerMBean(mbeanName, mbean);
    }

    public static synchronized void registerMBean(String mbeanName, Object mbean) {
        try {
            ObjectName name = new ObjectName(mbeanName);
            MBeanHelper.registerMBean(name, mbean);
        }
        catch (MalformedObjectNameException ex) {
            LOG.info("Cannot register '{}' as MBean:", mbean, (Object)ex);
        }
    }

    public static synchronized void registerMBean(ObjectName name, Object mbean) {
        try {
            LOG.trace("Registering '{}'...", (Object)name);
            server.registerMBean(mbean, name);
            LOG.debug("'{}' successful registered as MBean", (Object)name);
        }
        catch (InstanceAlreadyExistsException ex) {
            LOG.debug("'{}' is already registered.", (Object)name);
            LOG.trace("Details:", (Throwable)ex);
        }
        catch (MBeanRegistrationException ex) {
            LOG.info("Cannot register <{}> as MBean:", mbean, (Object)ex);
        }
        catch (NotCompliantMBeanException ex) {
            LOG.info("<{}> is not a compliant MBean:", mbean, (Object)ex);
        }
    }

    public static synchronized void unregisterMBean(String mbeanName) {
        try {
            ObjectName name = new ObjectName(mbeanName);
            MBeanHelper.unregisterMBean(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException("'" + mbeanName + "' is not a valid name", ex);
        }
    }

    public static synchronized void unregisterMBean(ObjectName name) {
        try {
            server.unregisterMBean(name);
            LOG.debug("MBean " + String.valueOf(name) + " successful unregistered");
        }
        catch (MBeanRegistrationException ex) {
            LOG.info("Cannot unregister '" + String.valueOf(name) + "':", (Throwable)ex);
        }
        catch (InstanceNotFoundException ex) {
            LOG.info("'" + String.valueOf(name) + "' not found:", (Throwable)ex);
        }
    }

    public static boolean isRegistered(String mbeanName) {
        ObjectName name = MBeanHelper.getAsObjectName(mbeanName);
        return MBeanHelper.isRegistered(name);
    }

    public static boolean isRegistered(ObjectName name) {
        try {
            ObjectInstance mbean = server.getObjectInstance(name);
            return mbean != null;
        }
        catch (InstanceNotFoundException ex) {
            LOG.trace("'" + String.valueOf(name) + "' not found:", (Throwable)ex);
            return false;
        }
    }

    public static boolean isRegistered(Object obj) {
        String mbeanName = MBeanHelper.getMBeanName(obj.getClass());
        return MBeanHelper.isRegistered(mbeanName);
    }

    public static ObjectInstance getObjectInstance(String name) throws InstanceNotFoundException {
        try {
            ObjectName mbeanName = new ObjectName(name);
            return MBeanHelper.getObjectInstance(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(name, e);
        }
    }

    public static ObjectInstance getObjectInstance(ObjectName mbeanName) throws InstanceNotFoundException {
        return server.getObjectInstance(mbeanName);
    }

    public static Object getAttribute(String mbeanName, String attributeName) throws JMException {
        try {
            ObjectName mbean = new ObjectName(mbeanName);
            return MBeanHelper.getAttribute(mbean, attributeName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(mbeanName, e);
        }
    }

    public static Object getAttribute(ObjectName mbean, String attributeName) throws JMException {
        try {
            return server.getAttribute(mbean, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalArgumentException(attributeName, e);
        }
    }

    public static TabularDataSupport createTabularDataSupport(CompositeType rowType, String[] itemNames) throws OpenDataException {
        TabularType tabularType = new TabularType("propertyTabularType", "properties tabular", rowType, itemNames);
        return new TabularDataSupport(tabularType);
    }
}

