/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.stat;

import java.net.URI;

public final class ClazzRecord
implements Comparable<ClazzRecord> {
    private final URI classpath;
    private final String classname;
    private final int count;

    public ClazzRecord(URI classpath, String classname) {
        this(classpath, classname, 0);
    }

    public ClazzRecord(URI classpath, String classname, int count) {
        this.classpath = classpath;
        this.classname = classname;
        this.count = count;
    }

    public String classname() {
        return this.classname;
    }

    public URI classpath() {
        return this.classpath;
    }

    public int count() {
        return this.count;
    }

    public static ClazzRecord fromCSV(String line) {
        String[] parts = line.split(";");
        return new ClazzRecord(URI.create(parts[0]), parts[1], Integer.parseInt(parts[2]));
    }

    public static String toCsvHeadline() {
        return "Classpath; Classname; Count";
    }

    public String toCSV() {
        return String.valueOf(this.classpath) + ";" + this.classname + ";" + this.count;
    }

    @Override
    public int compareTo(ClazzRecord other) {
        int n = this.classpath.compareTo(other.classpath);
        if (n == 0) {
            n = this.classname.compareTo(other.classname);
        }
        return n;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ClazzRecord) {
            return this.compareTo((ClazzRecord)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.classname.hashCode();
    }

    public String toString() {
        return this.toCSV();
    }
}

