/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.stat;

import clazzfish.monitor.ClasspathMonitor;
import clazzfish.monitor.internal.Config;
import clazzfish.monitor.io.ExtendedFile;
import clazzfish.monitor.jmx.MBeanFinder;
import clazzfish.monitor.stat.ClazzRecord;
import clazzfish.monitor.stat.ClazzStatisticMBean;
import clazzfish.monitor.util.Converter;
import clazzfish.monitor.util.Shutdowner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClazzStatistic
extends Shutdowner
implements ClazzStatisticMBean {
    private static final Logger log = LoggerFactory.getLogger(ClazzStatistic.class);
    private static final Executor EXECUTOR = Executors.newCachedThreadPool();
    private static final ClazzStatistic INSTANCE = new ClazzStatistic();
    private final ClasspathMonitor classpathMonitor;
    private final FutureTask<SortedSet<ClazzRecord>> allClasses;
    private final File csvFile;

    public static ClazzStatistic getInstance() {
        return INSTANCE;
    }

    private ClazzStatistic() {
        this(ClazzStatistic.getCsvFile());
    }

    ClazzStatistic(File csvFile) {
        this(csvFile, ClasspathMonitor.getInstance());
    }

    private ClazzStatistic(File csvFile, ClasspathMonitor classpathMonitor) {
        this.classpathMonitor = classpathMonitor;
        this.allClasses = ClazzStatistic.collectFutureClasses(classpathMonitor);
        this.csvFile = csvFile;
        log.debug("Statistics will be imported from / exported to '{}'.", (Object)csvFile);
    }

    private static FutureTask<SortedSet<ClazzRecord>> collectFutureClasses(ClasspathMonitor cpmon) {
        FutureTask<SortedSet<ClazzRecord>> classes = new FutureTask<SortedSet<ClazzRecord>>(() -> ClazzStatistic.collectClasses(cpmon));
        EXECUTOR.execute(classes);
        return classes;
    }

    private static SortedSet<ClazzRecord> collectClasses(ClasspathMonitor cpmon) {
        TreeSet<ClazzRecord> classes = new TreeSet<ClazzRecord>();
        for (String classname : cpmon.getClasspathClasses()) {
            URI uri = ClazzStatistic.getUri(cpmon, classname);
            classes.add(new ClazzRecord(uri, classname, 0));
        }
        return classes;
    }

    private static URI getUri(ClasspathMonitor cpmon, String classname) {
        String resource;
        URI uri = cpmon.whichClass(classname);
        String s = Objects.toString(uri, "");
        if (s.endsWith(resource = Converter.classToResource(classname))) {
            if ((s = s.substring(0, s.length() - resource.length() - 1)).endsWith("!")) {
                s = s.substring(0, s.length() - 1);
            }
            uri = URI.create(s);
        }
        return uri;
    }

    public void registerMeAsMBean() {
        MBeanFinder.registerMBean(this);
    }

    public SortedSet<ClazzRecord> getAllClasses() {
        try {
            return this.allClasses.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            log.info("Trying again to get all classes ({}).", (Object)ex.getMessage());
            log.debug("Details:", (Throwable)ex);
            return this.getAllClasses();
        }
    }

    public SortedSet<ClazzRecord> getStatistics() {
        TreeSet<ClazzRecord> statistics = new TreeSet<ClazzRecord>();
        Set loaded = this.classpathMonitor.getLoadedClassList().stream().map(Class::getName).collect(Collectors.toSet());
        for (ClazzRecord record : this.getAllClasses()) {
            if (loaded.contains(record.classname())) {
                statistics.add(new ClazzRecord(record.classpath(), record.classname(), record.count() + 1));
                continue;
            }
            statistics.add(record);
        }
        return statistics;
    }

    @Override
    public void logMe() {
        this.importCSV();
        try (StringWriter sw = new StringWriter();
             PrintWriter writer = new PrintWriter(sw);){
            this.writeCSV(writer);
            writer.flush();
            sw.flush();
            log.info("=== ClazzStatistic ===\n{}", (Object)sw);
        }
        catch (IOException ex) {
            log.error("Cannot log statistic:", (Throwable)ex);
        }
    }

    @Override
    public File getExportFile() {
        return this.csvFile;
    }

    @Override
    public File exportCSV() throws IOException {
        File dir = this.csvFile.getParentFile();
        if (dir.mkdirs()) {
            log.debug("Export dir {} was created.", (Object)dir);
        }
        return this.exportCSV(this.csvFile);
    }

    @Override
    public File exportCSV(String filename) throws IOException {
        return this.exportCSV(new File(filename)).getAbsoluteFile();
    }

    public File exportCSV(File csvFile) throws IOException {
        log.debug("Exporting statistics to '{}'...", (Object)csvFile);
        if (csvFile.exists()) {
            this.importCSV();
        } else {
            ExtendedFile.createDir(csvFile.getParentFile());
        }
        try (PrintWriter writer = new PrintWriter(csvFile);){
            this.writeCSV(writer);
        }
        log.info("Statistics exported to '{}'.", (Object)csvFile);
        return csvFile;
    }

    private void writeCSV(PrintWriter writer) {
        SortedSet<ClazzRecord> statistics = this.getStatistics();
        writer.println(ClazzRecord.toCsvHeadline());
        for (ClazzRecord rec : statistics) {
            writer.println(rec.toCSV());
        }
        log.debug("Statistics exported with {} lines.", (Object)statistics.size());
    }

    private void importCSV() {
        if (this.csvFile.exists()) {
            try {
                this.importCSV(this.csvFile);
            }
            catch (IOException ex) {
                log.info("History could not be imported from {} ({}).", (Object)this.csvFile, (Object)ex.getMessage());
                log.debug("Details:", (Throwable)ex);
            }
        } else {
            log.debug("No CSV file '{}' for import available.", (Object)this.csvFile);
        }
    }

    public void importCSV(File csvFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(csvFile));){
            while (reader.ready()) {
                ClazzRecord r;
                String line = reader.readLine();
                if (line.startsWith(ClazzRecord.toCsvHeadline()) || (r = ClazzRecord.fromCSV(line)).count() == 0) continue;
                String classname = r.classname();
                Optional<ClazzRecord> any = this.getAllClasses().stream().filter(cr -> classname.equals(cr.classname())).findAny();
                if (!any.isPresent()) continue;
                this.getAllClasses().remove(any.get());
                r = new ClazzRecord(r.classpath(), r.classname(), r.count() + any.get().count());
                this.getAllClasses().add(r);
            }
        }
        log.debug("Class records from {} imported.", (Object)csvFile);
    }

    @Override
    public void run() {
        try {
            this.exportCSV();
        }
        catch (IOException ex) {
            log.info("The class statistics could not be exported ({}).", (Object)ex.getMessage());
            log.debug("Details:", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "-" + String.valueOf(this.csvFile);
    }

    private static File getCsvFile() {
        String filename = Config.getEnvironment("clazzfish.statistics.file");
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            return new File(filename);
        }
        return new File(Config.DEFAULT.getDumpDir(), "ClazzStatistic.csv");
    }

    static {
        log.trace("{} will be registered as shudown hook.", (Object)INSTANCE);
        INSTANCE.addMeAsShutdownHook();
    }
}

