/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.util;

import clazzfish.monitor.util.Converter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionHelper.class);

    private ReflectionHelper() {
    }

    public static Field getField(Class<?> cl, String name) throws NoSuchFieldException {
        try {
            Field field = cl.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = cl.getSuperclass();
            if (superclass == null) {
                throw e;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("using " + String.valueOf(superclass) + " to get " + cl.getName() + "." + name + "...");
            }
            return ReflectionHelper.getField(superclass, name);
        }
    }

    public static boolean hasField(Object obj, String name) {
        return ReflectionHelper.hasField(obj.getClass(), name);
    }

    public static boolean hasField(Class<?> clazz, String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        try {
            ReflectionHelper.getField(clazz, name);
            return true;
        }
        catch (NoSuchFieldException ex) {
            LOG.debug("Will return false because {} has no field '{}' ({}).", new Object[]{clazz, name, ex});
            return false;
        }
    }

    public static Object getFieldValue(Object target, String name) throws ReflectiveOperationException {
        Field field = ReflectionHelper.getField(target.getClass(), name);
        return field.get(target);
    }

    public static void setFieldValue(Object target, String name, String value) throws ReflectiveOperationException {
        Field field = ReflectionHelper.getField(target.getClass(), name);
        field.set(target, value);
    }

    public static Collection<Field> getUninitializedNonStaticFields(Object obj) {
        ArrayList<Field> unitializedFields = new ArrayList<Field>();
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].setAccessible(true);
                if (fields[i].get(obj) != null || ReflectionHelper.isStatic(fields[i])) continue;
                unitializedFields.add(fields[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.info(String.valueOf(e) + " => " + String.valueOf(fields[i]) + " ignored");
                continue;
            }
            catch (IllegalAccessException e) {
                LOG.debug("Cannot access " + String.valueOf(fields[i]) + " => ignored: ", (Throwable)e);
            }
        }
        return unitializedFields;
    }

    public static boolean isStatic(Field field) {
        int m = field.getModifiers();
        return Modifier.isStatic(m);
    }

    public static String toShortString(Field field) {
        return field.getType().getSimpleName() + " " + field.getName();
    }

    public static String toShortString(Collection<Field> fields) {
        StringBuilder sbuf = new StringBuilder();
        for (Field field : fields) {
            sbuf.append(", ");
            sbuf.append(ReflectionHelper.toShortString(field));
        }
        return sbuf.substring(2);
    }

    public static Method getMethod(Class<?> cl, String name, Object ... args) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return ReflectionHelper.getMethod(cl, name, parameterTypes);
    }

    public static Method getMethod(Class<?> cl, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return cl.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException origException) {
            try {
                return ReflectionHelper.getMethodFromSuperclass(cl, name, origException, parameterTypes);
            }
            catch (NoSuchMethodException derived) {
                LOG.debug("Method '{}' also not found in superclass:", (Object)name, (Object)derived);
                throw origException;
            }
        }
    }

    private static Method getMethodFromSuperclass(Class<?> cl, String name, NoSuchMethodException origException, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return ReflectionHelper.findMethod(cl, name, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            Class<?> superclass = cl.getSuperclass();
            if (superclass == null) {
                LOG.debug("No method '{}' and no superclass for {} found:", new Object[]{name, cl, nsme});
                throw origException;
            }
            return ReflectionHelper.getMethod(superclass, name, parameterTypes);
        }
    }

    private static Method findMethod(Class<?> cl, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!name.equals(methods[i].getName()) || !ReflectionHelper.matchesParameters(methods[i], parameterTypes)) continue;
            return methods[i];
        }
        throw new NoSuchMethodException(cl.getName() + "." + name + "(" + Converter.toShortString(parameterTypes) + ")");
    }

    private static boolean matchesParameters(Method method, Class<?>[] matchingTypes) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != matchingTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (ReflectionHelper.matches(parameterTypes[i], matchingTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(Class<?> parameterType, Class<?> matchingType) {
        if (parameterType.isAssignableFrom(matchingType)) {
            return true;
        }
        if (parameterType.isPrimitive()) {
            HashMap<Class<Comparable<Boolean>>, Class<Boolean>> mapping = new HashMap<Class<Comparable<Boolean>>, Class<Boolean>>();
            mapping.put(Boolean.TYPE, Boolean.class);
            mapping.put(Byte.TYPE, Byte.class);
            mapping.put(Character.TYPE, Character.class);
            mapping.put(Short.TYPE, Short.class);
            mapping.put(Integer.TYPE, Integer.class);
            mapping.put(Long.TYPE, Long.class);
            mapping.put(Float.TYPE, Float.class);
            mapping.put(Double.TYPE, Double.class);
            mapping.put(Boolean.TYPE, Boolean.class);
            Class mappedType = (Class)mapping.get(parameterType);
            if (mappedType == null) {
                LOG.warn("unknown primitive type \"" + String.valueOf(parameterType) + "\" not yet supported - sorry!");
                return false;
            }
            return matchingType.equals(mappedType);
        }
        return false;
    }

    public static Object invokeMethod(Object target, String name, Object ... args) {
        try {
            Method method = ReflectionHelper.getMethod(target.getClass(), name, args);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("no method \"" + name + "(" + ReflectionHelper.toParamString(args) + ")\" in " + String.valueOf(target.getClass()), e);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("can't access method \"" + name + "\" in " + String.valueOf(target.getClass()), iae);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException("exception in method \"" + name + "\" of " + String.valueOf(target.getClass()), ite.getTargetException());
        }
    }

    private static String toParamString(Object[] args) {
        Object[] paramTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            paramTypes[i] = args[i].getClass();
        }
        return Converter.toShortString(paramTypes);
    }

    public static boolean hasId(Object obj) {
        return ReflectionHelper.hasId(obj.getClass());
    }

    public static boolean hasId(Class<?> clazz) {
        if (ReflectionHelper.getIdField(clazz) != null) {
            return true;
        }
        return ReflectionHelper.getIdGetter(clazz) != null;
    }

    public static Object getId(Object obj) {
        Field idField = ReflectionHelper.getIdField(obj.getClass());
        try {
            if (idField != null) {
                idField.setAccessible(true);
                return idField.get(obj);
            }
            Method getter = ReflectionHelper.getIdGetter(obj.getClass());
            if (getter == null) {
                throw new IllegalArgumentException("no getter for '" + String.valueOf(obj) + "' available");
            }
            getter.setAccessible(true);
            return getter.invoke(obj, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("cannot get id of " + String.valueOf(obj), ex);
        }
    }

    private static Field getIdField(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!"id".equalsIgnoreCase(fields[i].getName())) continue;
            return fields[i];
        }
        Class<?> superclass = clazz.getSuperclass();
        return superclass == null ? null : ReflectionHelper.getIdField(superclass);
    }

    private static Method getIdGetter(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!"getid".equalsIgnoreCase(methods[i].getName())) continue;
            return methods[i];
        }
        Class<?> superclass = clazz.getSuperclass();
        return superclass == null ? null : ReflectionHelper.getIdGetter(superclass);
    }
}

