/*
 * Decompiled with CFR 0.152.
 */
package clazzfish.monitor.util;

import clazzfish.monitor.ClassloaderType;
import clazzfish.monitor.util.Shutdownable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Shutdowner
extends Thread
implements Shutdownable {
    private static final Logger log = LoggerFactory.getLogger(Shutdowner.class);
    private boolean shutdownHook = false;

    @Override
    public synchronized boolean isShutdownHook() {
        return this.shutdownHook;
    }

    @Override
    public void addMeAsShutdownHook() {
        ClassloaderType type = ClassloaderType.getCurrentClassloaderType();
        if (type.isWeb()) {
            log.info("Registration as shutdown hook is ignored inside {}.", (Object)type);
        } else if (!this.shutdownHook) {
            Runtime.getRuntime().addShutdownHook(this);
            this.shutdownHook = true;
            log.debug("{} is registered as shutdown hook", (Object)this);
        }
    }

    @Override
    public void removeMeAsShutdownHook() {
        if (this.shutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this);
            this.shutdownHook = false;
            log.debug("{} is de-registered as shutdown hook", (Object)this);
        }
    }
}

